#!/usr/bin/bash

for epsilon in 0.2 0.1 0.05
do
    for delta in 0.2 0.1 0.05
    do
	echo poetry run python exp_bme_vs_bai.py --epsilon $epsilon --delta $delta --run --plot
	poetry run python exp_bme_vs_bai.py --epsilon $epsilon --delta $delta --run --plot
    done
done


for players in 4 6 8
do
    for types in 4 6 8
    do
	echo poetry run python exp_bandit_sample.py --players $players --types $types --run --plot
	poetry run python exp_bandit_sample.py --players $players --types $types --run --plot
    done
done


echo poetry run python exp_bandit_trend.py --players 128 --types 4
poetry run python exp_bandit_trend.py --players 128 --types 4

echo poetry run python exp_bandit_trend.py --players 8 --types 16 --rotate
poetry run python exp_bandit_trend.py --players 8 --types 16 --rotate


echo poetry run python exp_amd_bb_ir.py --players 8 --types 8
poetry run python exp_amd_bb_ir.py --players 8 --types 8

echo poetry run python exp_amd_bb_ir.py --players 8 --types 8 --IR
poetry run python exp_amd_bb_ir.py --players 8 --types 8 --IR


for epsilon in 1.0 0.5 0.4 0.3 0.25 0.2 0.15
do    
    echo poetry run python exp_rmse.py --players 8 --types 4 --epsilon $epsilon
    poetry run python exp_rmse.py --players 8 --types 4 --epsilon $epsilon
done

echo poetry run python exp_rmse.py --players 8 --types 4 --plot
poetry run python exp_rmse.py --players 8 --types 4 --plot
