import os
import tqdm
import requests


def download_imagenet_o():
    csv_path = './data/openimage-v3-test-images.csv'
    openimage_o_path = './data/openimage_o.txt'
    save_path = '/mnt/bn/benchmark-dataset/peisen/TIP_SSOD/data/OOD/As_ImageNet_OOD/openimage-o'
    os.makedirs(save_path, exist_ok=True)

    with open(openimage_o_path, 'r') as f:
        lines = f.readlines()
    target_ids = [line.strip().split('.')[0] for line in lines]

    with open(csv_path, 'r') as f:
        lines = f.readlines()
    
    id2url = dict()
    for line in lines[1:]:
        line_list = line.strip().split(',')
        id, url = line_list[0], line_list[2]
        id2url[id] = url
    
    for id in tqdm.tqdm(target_ids):
        try:
            url = id2url[id]
            content = requests.get(url).content
            save_name = '%s/%s.jpg' % (save_path, id)
            with open(save_name, 'wb') as f:
                f.write(content)
            f.close()
        except:
            print('Error in Image: %s' % id)


if __name__ == '__main__':
    download_imagenet_o()
