import numpy as np
from pwa import PWA
import pickle

dx = 0.05
dy = 0.05
xrange = np.arange(-1., 1., dx)
yrange = np.arange(-1., 1., dy)
elevation = [30]
nu = np.ones((1, 1))

dyn = PWA()

data, X, Y = dyn.visualize_net(xrange, yrange, dyn, elevation, nu)

# data is in shape (4,1600)
x = data[:2].T # (1600,2)
y = data[2:].T # (1600,2)

# there are no "actions" here, thus n_his and n_rollout will be 1
# define the actions to have dimension 2
# therefore one "episode" is just shape (2, 2 + 2)
# [[s/x_data, action],
#  [s'/y_data, action]]
dataset = []
for i in range(len(x)):
    arr = np.zeros((2,4))
    arr[0,:2] = x[i]
    arr[0,2:] = 0.
    arr[1,:2] = y[i]
    arr[1,2:] = 0.
    dataset.append(arr)

with open("data/pwa_data.p", 'wb') as fp:
    pickle.dump(dataset, fp)
