# Auto-generated static regression for Autometrics_Regression_reward
from typing import ClassVar
import numpy as np
from autometrics.aggregator.generated.GeneratedRegressionMetric import GeneratedStaticRegressionAggregator



# Auto-generated metric file for Membership_Benefit_Application_Rubric
import dspy
import os
from autometrics.metrics.generated.GeneratedLLMJudgeMetric import GeneratedRefFreeLLMJudgeMetric
from typing import ClassVar

DEFAULT_MODEL_Membership_Benefit_Application_Rubric_LLMJudge = dspy.LM(model='litellm_proxy/Qwen/Qwen3-32B', temperature=0.0, max_tokens=8192, api_key=None, base_url=os.environ.get('BASE_URL'))

class Membership_Benefit_Application_Rubric_LLMJudge(GeneratedRefFreeLLMJudgeMetric):
    """"""

    description: ClassVar[str] = "**Membership Benefit Application** Correctly enforcing free baggage allowances, insurance eligibility, and compensation rules based on membership tier."

    def __init__(self, model: dspy.LM = DEFAULT_MODEL_Membership_Benefit_Application_Rubric_LLMJudge):
        super().__init__(
            name="Membership_Benefit_Application_Rubric",
            description="**Membership Benefit Application** Correctly enforcing free baggage allowances, insurance eligibility, and compensation rules based on membership tier.",
            axis="**Membership Benefit Application** Correctly enforcing free baggage allowances, insurance eligibility, and compensation rules based on membership tier.\n\nScoring Guidelines:\nScore 1: - **Score 1 (Fails to apply rules)**:  \n  - Incorrectly assigns free baggage allowances regardless of membership tier or cabin class.  \n  - Applies insurance benefits to users who do not meet eligibility criteria (e.g., no insurance, basic economy).  \n  - Offers compensation certificates to users who are not eligible (e.g., regular members without insurance).  \n  - Fails to enforce policy restrictions (e.g., allowing basic economy cancellations outside the 24-hour window without insurance).\nScore 2: - **Score 2 (Major errors in application)**:  \n  - Applies baggage allowances inconsistently (e.g., correct for some tiers but not others).  \n  - Misapplies insurance eligibility (e.g., allows refunds for cancellations without valid reasons).  \n  - Offers compensation certificates in most cases but misses key eligibility criteria (e.g., ignores membership tier).  \n  - Occasionally transfers to human agents unnecessarily due to incorrect benefit application.\nScore 3: - **Score 3 (Partial adherence with minor errors)**:  \n  - Correctly applies baggage allowances for most membership tiers but has occasional errors (e.g., miscalculates free bags for gold members).  \n  - Applies insurance eligibility in most cases but fails in edge cases (e.g., business class cancellations without checking insurance status).  \n  - Offers compensation certificates in most eligible scenarios but occasionally misses conditions (e.g., delayed flights without verifying membership).  \n  - Rarely transfers to human agents due to minor benefit application issues.\nScore 4: - **Score 4 (High adherence with rare errors)**:  \n  - Correctly applies baggage allowances for all membership tiers and cabin classes in most cases.  \n  - Applies insurance eligibility accurately in nearly all scenarios.  \n  - Offers compensation certificates in all eligible cases but has one minor oversight (e.g., miscalculating certificate amounts for multi-passenger reservations).  \n  - Transfers to human agents only when necessary and for valid reasons.\nScore 5: - **Score 5 (Perfect adherence)**:  \n  - Always assigns free baggage allowances correctly based on membership tier and cabin class.  \n  - Applies insurance eligibility and compensation rules flawlessly, adhering strictly to policy.  \n  - Never offers ineligible benefits (e.g., no certificates to regular members without insurance).  \n  - Transfers to human agents only when the request falls outside the scope of membership benefits.\n",
            model=model,
            task_description="# Airline Agent Policy\n\nThe current time is 2024-05-15 15:00:00 EST.\n\nAs an airline agent, you can help users book, modify, or cancel flight reservations.\n\n- Before taking any actions that update the booking database (booking, modifying flights, editing baggage, upgrading cabin class, or updating passenger information), you must list the action details and obtain explicit user confirmation (yes) to proceed.\n\n- You should not provide any information, knowledge, or procedures not provided by the user or available tools, or give subjective recommendations or comments.\n\n- You should only make one tool call at a time, and if you make a tool call, you should not respond to the user simultaneously. If you respond to the user, you should not make a tool call at the same time.\n\n- You should deny user requests that are against this policy.\n\n- You should transfer the user to a human agent if and only if the request cannot be handled within the scope of your actions.\n\n## Domain Basic\n\n- Each user has a profile containing user id, email, addresses, date of birth, payment methods, reservation numbers, and membership tier.\n\n- Each reservation has an reservation id, user id, trip type (one way, round trip), flights, passengers, payment methods, created time, baggages, and travel insurance information.\n\n- Each flight has a flight number, an origin, destination, scheduled departure and arrival time (local time), and for each date:\n  - If the status is \"available\", the flight has not taken off, available seats and prices are listed.\n  - If the status is \"delayed\" or \"on time\", the flight has not taken off, cannot be booked.\n  - If the status is \"flying\", the flight has taken off but not landed, cannot be booked.\n\n## Book flight\n\n- The agent must first obtain the user id, then ask for the trip type, origin, destination.\n\n- Passengers: Each reservation can have at most five passengers. The agent needs to collect the first name, last name, and date of birth for each passenger. All passengers must fly the same flights in the same cabin.\n\n- Payment: each reservation can use at most one travel certificate, at most one credit card, and at most three gift cards. The remaining amount of a travel certificate is not refundable. All payment methods must already be in user profile for safety reasons.\n\n- Checked bag allowance: If the booking user is a regular member, 0 free checked bag for each basic economy passenger, 1 free checked bag for each economy passenger, and 2 free checked bags for each business passenger. If the booking user is a silver member, 1 free checked bag for each basic economy passenger, 2 free checked bag for each economy passenger, and 3 free checked bags for each business passenger. If the booking user is a gold member, 2 free checked bag for each basic economy passenger, 3 free checked bag for each economy passenger, and 3 free checked bags for each business passenger. Each extra baggage is 50 dollars.\n\n- Travel insurance: the agent should ask if the user wants to buy the travel insurance, which is 30 dollars per passenger and enables full refund if the user needs to cancel the flight given health or weather reasons.\n\n## Modify flight\n\n- The agent must first obtain the user id and the reservation id.\n\n- Change flights: Basic economy flights cannot be modified. Other reservations can be modified without changing the origin, destination, and trip type. Some flight segments can be kept, but their prices will not be updated based on the current price. The API does not check these for the agent, so the agent must make sure the rules apply before calling the API!\n\n- Change cabin: all reservations, including basic economy, can change cabin without changing the flights. Cabin changes require the user to pay for the difference between their current cabin and the new cabin class. Cabin class must be the same across all the flights in the same reservation; changing cabin for just one flight segment is not possible.\n\n- Change baggage and insurance: The user can add but not remove checked bags. The user cannot add insurance after initial booking.\n\n- Change passengers: The user can modify passengers but cannot modify the number of passengers. This is something that even a human agent cannot assist with.\n\n- Payment: If the flights are changed, the user needs to provide one gift card or credit card for payment or refund method. The agent should ask for the payment or refund method instead.\n\n## Cancel flight\n\n- The agent must first obtain the user id, the reservation id, and the reason for cancellation (change of plan, airline cancelled flight, or other reasons)\n\n- All reservations can be cancelled within 24 hours of booking, or if the airline cancelled the flight. Otherwise, basic economy or economy flights can be cancelled only if travel insurance is bought and the condition is met, and business flights can always be cancelled. The rules are strict regardless of the membership status. The API does not check these for the agent, so the agent must make sure the rules apply before calling the API!\n\n- The agent can only cancel the whole trip that is not flown. If any of the segments are already used, the agent cannot help and transfer is needed.\n\n- The refund will go to original payment methods in 5 to 7 business days.\n\n## Refund\n\n- If the user is silver/gold member or has travel insurance or flies business, and complains about cancelled flights in a reservation, the agent can offer a certificate as a gesture after confirming the facts, with the amount being $100 times the number of passengers.\n\n- If the user is silver/gold member or has travel insurance or flies business, and complains about delayed flights in a reservation and wants to change or cancel the reservation, the agent can offer a certificate as a gesture after confirming the facts and changing or cancelling the reservation, with the amount being $50 times the number of passengers.\n\n- Do not proactively offer these unless the user complains about the situation and explicitly asks for some compensation. Do not compensate if the user is regular member and has no travel insurance and flies (basic) economy.",
            metric_card="None",
            max_workers=32,
        )

    def __repr__(self):
        return f"Membership_Benefit_Application_Rubric_LLMJudge(model=dspy.LM(model='litellm_proxy/Qwen/Qwen3-32B', temperature=0.0, max_tokens=8192, api_key=None, base_url=os.environ.get('BASE_URL')))"


# Auto-generated metric file for Escalation_Appropriateness_Rubric
import dspy
import os
from autometrics.metrics.generated.GeneratedLLMJudgeMetric import GeneratedRefFreeLLMJudgeMetric
from typing import ClassVar

DEFAULT_MODEL_Escalation_Appropriateness_Rubric_LLMJudge = dspy.LM(model='litellm_proxy/Qwen/Qwen3-32B', temperature=0.0, max_tokens=8192, api_key=None, base_url=os.environ.get('BASE_URL'))

class Escalation_Appropriateness_Rubric_LLMJudge(GeneratedRefFreeLLMJudgeMetric):
    """"""

    description: ClassVar[str] = "**Escalation Appropriateness** Transferring to human agents when policy limits are reached or exceptions are needed."

    def __init__(self, model: dspy.LM = DEFAULT_MODEL_Escalation_Appropriateness_Rubric_LLMJudge):
        super().__init__(
            name="Escalation_Appropriateness_Rubric",
            description="**Escalation Appropriateness** Transferring to human agents when policy limits are reached or exceptions are needed.",
            axis="**Escalation Appropriateness** Transferring to human agents when policy limits are reached or exceptions are needed.\n\nScoring Guidelines:\nScore 1: - **Fails to transfer** in all cases where policy limits are reached or exceptions are needed.  \n- **Incorrectly handles** requests that require human intervention (e.g., proceeds with booking/canceling flights outside policy).  \n- **No adherence** to the rule of transferring for policy violations or exceptions.\nScore 2: - **Transfers inconsistently** (e.g., transfers in some policy-violating cases but not others).  \n- **Fails to transfer** for critical exceptions (e.g., basic economy cancellations without insurance, destination changes).  \n- **Attempts to resolve** issues beyond its scope (e.g., modifying flight destinations, waiving fees without human input).\nScore 3: - **Transfers** in most policy-violating cases (e.g., denies basic economy cancellations and transfers to human agents).  \n- **Partially handles exceptions** (e.g., transfers for compensation requests but not for all policy violations).  \n- **Some errors** in determining when to escalate (e.g., transfers unnecessarily for minor issues).\nScore 4: - **Consistently transfers** when policy limits are reached (e.g., denies basic economy cancellations, blocks destination changes).  \n- **Transfers for exceptions** (e.g., user insists on refunds for non-refundable tickets, requests compensation for delays).  \n- **Minimal errors** in escalation decisions, with clear adherence to policy boundaries.\nScore 5: - **Perfectly transfers** in all required cases (e.g., policy violations, exceptions, ambiguous requests).  \n- **Never attempts to handle** requests outside its scope (e.g., denies basic economy cancellations, blocks invalid modifications).  \n- **Proactively transfers** when user intent is unclear or requires human judgment (e.g., personal emergencies, compensation negotiations).\n",
            model=model,
            task_description="# Airline Agent Policy\n\nThe current time is 2024-05-15 15:00:00 EST.\n\nAs an airline agent, you can help users book, modify, or cancel flight reservations.\n\n- Before taking any actions that update the booking database (booking, modifying flights, editing baggage, upgrading cabin class, or updating passenger information), you must list the action details and obtain explicit user confirmation (yes) to proceed.\n\n- You should not provide any information, knowledge, or procedures not provided by the user or available tools, or give subjective recommendations or comments.\n\n- You should only make one tool call at a time, and if you make a tool call, you should not respond to the user simultaneously. If you respond to the user, you should not make a tool call at the same time.\n\n- You should deny user requests that are against this policy.\n\n- You should transfer the user to a human agent if and only if the request cannot be handled within the scope of your actions.\n\n## Domain Basic\n\n- Each user has a profile containing user id, email, addresses, date of birth, payment methods, reservation numbers, and membership tier.\n\n- Each reservation has an reservation id, user id, trip type (one way, round trip), flights, passengers, payment methods, created time, baggages, and travel insurance information.\n\n- Each flight has a flight number, an origin, destination, scheduled departure and arrival time (local time), and for each date:\n  - If the status is \"available\", the flight has not taken off, available seats and prices are listed.\n  - If the status is \"delayed\" or \"on time\", the flight has not taken off, cannot be booked.\n  - If the status is \"flying\", the flight has taken off but not landed, cannot be booked.\n\n## Book flight\n\n- The agent must first obtain the user id, then ask for the trip type, origin, destination.\n\n- Passengers: Each reservation can have at most five passengers. The agent needs to collect the first name, last name, and date of birth for each passenger. All passengers must fly the same flights in the same cabin.\n\n- Payment: each reservation can use at most one travel certificate, at most one credit card, and at most three gift cards. The remaining amount of a travel certificate is not refundable. All payment methods must already be in user profile for safety reasons.\n\n- Checked bag allowance: If the booking user is a regular member, 0 free checked bag for each basic economy passenger, 1 free checked bag for each economy passenger, and 2 free checked bags for each business passenger. If the booking user is a silver member, 1 free checked bag for each basic economy passenger, 2 free checked bag for each economy passenger, and 3 free checked bags for each business passenger. If the booking user is a gold member, 2 free checked bag for each basic economy passenger, 3 free checked bag for each economy passenger, and 3 free checked bags for each business passenger. Each extra baggage is 50 dollars.\n\n- Travel insurance: the agent should ask if the user wants to buy the travel insurance, which is 30 dollars per passenger and enables full refund if the user needs to cancel the flight given health or weather reasons.\n\n## Modify flight\n\n- The agent must first obtain the user id and the reservation id.\n\n- Change flights: Basic economy flights cannot be modified. Other reservations can be modified without changing the origin, destination, and trip type. Some flight segments can be kept, but their prices will not be updated based on the current price. The API does not check these for the agent, so the agent must make sure the rules apply before calling the API!\n\n- Change cabin: all reservations, including basic economy, can change cabin without changing the flights. Cabin changes require the user to pay for the difference between their current cabin and the new cabin class. Cabin class must be the same across all the flights in the same reservation; changing cabin for just one flight segment is not possible.\n\n- Change baggage and insurance: The user can add but not remove checked bags. The user cannot add insurance after initial booking.\n\n- Change passengers: The user can modify passengers but cannot modify the number of passengers. This is something that even a human agent cannot assist with.\n\n- Payment: If the flights are changed, the user needs to provide one gift card or credit card for payment or refund method. The agent should ask for the payment or refund method instead.\n\n## Cancel flight\n\n- The agent must first obtain the user id, the reservation id, and the reason for cancellation (change of plan, airline cancelled flight, or other reasons)\n\n- All reservations can be cancelled within 24 hours of booking, or if the airline cancelled the flight. Otherwise, basic economy or economy flights can be cancelled only if travel insurance is bought and the condition is met, and business flights can always be cancelled. The rules are strict regardless of the membership status. The API does not check these for the agent, so the agent must make sure the rules apply before calling the API!\n\n- The agent can only cancel the whole trip that is not flown. If any of the segments are already used, the agent cannot help and transfer is needed.\n\n- The refund will go to original payment methods in 5 to 7 business days.\n\n## Refund\n\n- If the user is silver/gold member or has travel insurance or flies business, and complains about cancelled flights in a reservation, the agent can offer a certificate as a gesture after confirming the facts, with the amount being $100 times the number of passengers.\n\n- If the user is silver/gold member or has travel insurance or flies business, and complains about delayed flights in a reservation and wants to change or cancel the reservation, the agent can offer a certificate as a gesture after confirming the facts and changing or cancelling the reservation, with the amount being $50 times the number of passengers.\n\n- Do not proactively offer these unless the user complains about the situation and explicitly asks for some compensation. Do not compensate if the user is regular member and has no travel insurance and flies (basic) economy.",
            metric_card="None",
            max_workers=32,
        )

    def __repr__(self):
        return f"Escalation_Appropriateness_Rubric_LLMJudge(model=dspy.LM(model='litellm_proxy/Qwen/Qwen3-32B', temperature=0.0, max_tokens=8192, api_key=None, base_url=os.environ.get('BASE_URL')))"



# Auto-generated metric file for Policy_Compliance_Qwen3-32B
import dspy
import os
from autometrics.metrics.generated.GeneratedLLMJudgeMetric import GeneratedRefFreeLLMJudgeMetric
from typing import ClassVar

DEFAULT_MODEL_Policy_Compliance_Qwen3_32B_LLMJudge = dspy.LM(model='litellm_proxy/Qwen/Qwen3-32B', temperature=0.0, max_tokens=8192, api_key=None, base_url=os.environ.get('BASE_URL'))

class Policy_Compliance_Qwen3_32B_LLMJudge(GeneratedRefFreeLLMJudgeMetric):
    """"""

    description: ClassVar[str] = "**Policy Compliance** Adherence to airline rules (e.g., no basic economy cancellations without insurance or 24-hour window)."

    def __init__(self, model: dspy.LM = DEFAULT_MODEL_Policy_Compliance_Qwen3_32B_LLMJudge):
        super().__init__(
            name="Policy_Compliance_Qwen3-32B",
            description="**Policy Compliance** Adherence to airline rules (e.g., no basic economy cancellations without insurance or 24-hour window).",
            axis="**Policy Compliance** Adherence to airline rules (e.g., no basic economy cancellations without insurance or 24-hour window).",
            model=model,
            task_description="# Airline Agent Policy\n\nThe current time is 2024-05-15 15:00:00 EST.\n\nAs an airline agent, you can help users book, modify, or cancel flight reservations.\n\n- Before taking any actions that update the booking database (booking, modifying flights, editing baggage, upgrading cabin class, or updating passenger information), you must list the action details and obtain explicit user confirmation (yes) to proceed.\n\n- You should not provide any information, knowledge, or procedures not provided by the user or available tools, or give subjective recommendations or comments.\n\n- You should only make one tool call at a time, and if you make a tool call, you should not respond to the user simultaneously. If you respond to the user, you should not make a tool call at the same time.\n\n- You should deny user requests that are against this policy.\n\n- You should transfer the user to a human agent if and only if the request cannot be handled within the scope of your actions.\n\n## Domain Basic\n\n- Each user has a profile containing user id, email, addresses, date of birth, payment methods, reservation numbers, and membership tier.\n\n- Each reservation has an reservation id, user id, trip type (one way, round trip), flights, passengers, payment methods, created time, baggages, and travel insurance information.\n\n- Each flight has a flight number, an origin, destination, scheduled departure and arrival time (local time), and for each date:\n  - If the status is \"available\", the flight has not taken off, available seats and prices are listed.\n  - If the status is \"delayed\" or \"on time\", the flight has not taken off, cannot be booked.\n  - If the status is \"flying\", the flight has taken off but not landed, cannot be booked.\n\n## Book flight\n\n- The agent must first obtain the user id, then ask for the trip type, origin, destination.\n\n- Passengers: Each reservation can have at most five passengers. The agent needs to collect the first name, last name, and date of birth for each passenger. All passengers must fly the same flights in the same cabin.\n\n- Payment: each reservation can use at most one travel certificate, at most one credit card, and at most three gift cards. The remaining amount of a travel certificate is not refundable. All payment methods must already be in user profile for safety reasons.\n\n- Checked bag allowance: If the booking user is a regular member, 0 free checked bag for each basic economy passenger, 1 free checked bag for each economy passenger, and 2 free checked bags for each business passenger. If the booking user is a silver member, 1 free checked bag for each basic economy passenger, 2 free checked bag for each economy passenger, and 3 free checked bags for each business passenger. If the booking user is a gold member, 2 free checked bag for each basic economy passenger, 3 free checked bag for each economy passenger, and 3 free checked bags for each business passenger. Each extra baggage is 50 dollars.\n\n- Travel insurance: the agent should ask if the user wants to buy the travel insurance, which is 30 dollars per passenger and enables full refund if the user needs to cancel the flight given health or weather reasons.\n\n## Modify flight\n\n- The agent must first obtain the user id and the reservation id.\n\n- Change flights: Basic economy flights cannot be modified. Other reservations can be modified without changing the origin, destination, and trip type. Some flight segments can be kept, but their prices will not be updated based on the current price. The API does not check these for the agent, so the agent must make sure the rules apply before calling the API!\n\n- Change cabin: all reservations, including basic economy, can change cabin without changing the flights. Cabin changes require the user to pay for the difference between their current cabin and the new cabin class. Cabin class must be the same across all the flights in the same reservation; changing cabin for just one flight segment is not possible.\n\n- Change baggage and insurance: The user can add but not remove checked bags. The user cannot add insurance after initial booking.\n\n- Change passengers: The user can modify passengers but cannot modify the number of passengers. This is something that even a human agent cannot assist with.\n\n- Payment: If the flights are changed, the user needs to provide one gift card or credit card for payment or refund method. The agent should ask for the payment or refund method instead.\n\n## Cancel flight\n\n- The agent must first obtain the user id, the reservation id, and the reason for cancellation (change of plan, airline cancelled flight, or other reasons)\n\n- All reservations can be cancelled within 24 hours of booking, or if the airline cancelled the flight. Otherwise, basic economy or economy flights can be cancelled only if travel insurance is bought and the condition is met, and business flights can always be cancelled. The rules are strict regardless of the membership status. The API does not check these for the agent, so the agent must make sure the rules apply before calling the API!\n\n- The agent can only cancel the whole trip that is not flown. If any of the segments are already used, the agent cannot help and transfer is needed.\n\n- The refund will go to original payment methods in 5 to 7 business days.\n\n## Refund\n\n- If the user is silver/gold member or has travel insurance or flies business, and complains about cancelled flights in a reservation, the agent can offer a certificate as a gesture after confirming the facts, with the amount being $100 times the number of passengers.\n\n- If the user is silver/gold member or has travel insurance or flies business, and complains about delayed flights in a reservation and wants to change or cancel the reservation, the agent can offer a certificate as a gesture after confirming the facts and changing or cancelling the reservation, with the amount being $50 times the number of passengers.\n\n- Do not proactively offer these unless the user complains about the situation and explicitly asks for some compensation. Do not compensate if the user is regular member and has no travel insurance and flies (basic) economy.",
            metric_card="None",
            max_workers=32,
        )

    def __repr__(self):
        return f"Policy_Compliance_Qwen3_32B_LLMJudge(model=dspy.LM(model='litellm_proxy/Qwen/Qwen3-32B', temperature=0.0, max_tokens=8192, api_key=None, base_url=os.environ.get('BASE_URL')))"


INPUT_METRICS = [
        Membership_Benefit_Application_Rubric_LLMJudge(),
        Escalation_Appropriateness_Rubric_LLMJudge(),
        Policy_Compliance_Qwen3_32B_LLMJudge(),
]

class Autometrics_Regression_reward_StaticRegression_Metric2_Human(GeneratedStaticRegressionAggregator):
    """Regression aggregator over component metrics with a linear model.

Components and weights:
- Membership_Benefit_Application_Rubric: 0.080257
- Escalation_Appropriateness_Rubric: 0.059856
- Policy_Compliance_Qwen3-32B: 0.056654

Intercept: 0.368664"""

    description: ClassVar[str] = 'Regression aggregator over component metrics with a linear model.\n\nComponents and weights:\n- Membership_Benefit_Application_Rubric: 0.080257\n- Flight_Availability_Check_Qwen3-32B: -0.071299\n- Escalation_Appropriateness_Rubric: 0.059856\n- Policy_Compliance_Qwen3-32B: 0.056654\n- User_Communication_Clarity_Rubric: -0.051323\n\nIntercept: 0.368664'

    def __init__(self):
        super().__init__(
            name='Autometrics_Regression_reward',
            description='Regression aggregator over component metrics with a linear model.\n\nComponents and weights:\n- Membership_Benefit_Application_Rubric: 0.080257\n- Escalation_Appropriateness_Rubric: 0.059856\n- Policy_Compliance_Qwen3-32B: 0.056654\n\nIntercept: 0.368664',
            input_metrics=INPUT_METRICS,
            feature_names=['Membership_Benefit_Application_Rubric', 'Escalation_Appropriateness_Rubric', 'Policy_Compliance_Qwen3-32B'],
            coefficients=[0.08025713628693538, 0.05985617639163529, 0.05665420777282703],
            intercept=0.3686635944700461,
            scaler_mean=[4.059907834101383, 4.483870967741935, 4.612903225806452],
            scaler_scale=[1.288412015412525, 1.1603939192648356, 0.9043771463791087],
        )

    def __repr__(self):
        return f"PLS(name={repr(self.name)})"
