"""
Train a diffusion model on images.
"""

import argparse

from cm import dist_util, logger
from cm.image_datasets import load_data
from cm.resample import create_named_schedule_sampler
from cm.script_util import (
    model_and_diffusion_defaults,
    create_model_and_diffusion,
    cm_train_defaults,
    ctm_train_defaults,
    ctm_loss_defaults,
    ctm_data_defaults,
    add_dict_to_argparser,
    create_ema_and_scales_fn,
)
from cm.train_util import CMTrainLoop
import torch.distributed as dist
import copy
import cm.enc_dec_lib as enc_dec_lib
import torch as th


def main():
    args = create_argparser().parse_args()

    dist_util.setup_dist(args.device_id)
    logger.configure(dir=args.out_dir)

    data = load_data(
        data_name=args.data_name,
        data_dir=args.data_dir,
        batch_size=args.global_batch_size,
        image_size=args.image_size,
        class_cond=args.class_cond,
        train_classes=args.train_classes,
        num_workers=10,
        type=args.type,
        deterministic=True,
        flip_ratio=1.0
    )

    logger.log("training...")


def create_argparser():
    defaults = dict(
        out_dir="",
        data_dir="",
        schedule_sampler="uniform",
        lr=1e-4,
        weight_decay=0.0,
        lr_anneal_steps=0,
        global_batch_size=2048,
        batch_size=-1,
        microbatch=-1,  # -1 disables microbatches
        ema_rate="0.9999",  # comma-separated list of EMA values
        log_interval=10,
        save_interval=10000,
        resume_checkpoint="",
        use_fp16=False,
        fp16_scale_growth=1e-3,
        device_id=0,
    )
    defaults.update(model_and_diffusion_defaults())
    defaults.update(cm_train_defaults())
    defaults.update(ctm_train_defaults())
    defaults.update(ctm_loss_defaults())
    defaults.update(ctm_data_defaults())
    defaults.update()
    parser = argparse.ArgumentParser()
    add_dict_to_argparser(parser, defaults)
    return parser


if __name__ == "__main__":
    main()
