import json
import typing
from pathlib import Path

import torch
from torch.utils.data import Dataset

from src.globals import *

REMOTE_ROOT = f"{REMOTE_ROOT_URL}/data/dsets"


class CounterFactDataset(Dataset):
    def __init__(
        self,
        data_dir: str,
        multi: bool = False,
        size: typing.Optional[int] = None,
        absolute_path: bool = False,
        *args,
        **kwargs,
    ):
        if not absolute_path:
            data_dir = Path(data_dir)
            cf_loc = data_dir / (
                "counterfact.json" if not multi else "multi_counterfact.json"
            )
            if not cf_loc.exists():
                remote_url = (
                    f"{REMOTE_ROOT}/{'multi_' if multi else ''}counterfact.json"
                )
                print(f"{cf_loc} does not exist. Downloading from {remote_url}")
                data_dir.mkdir(exist_ok=True, parents=True)
                torch.hub.download_url_to_file(remote_url, cf_loc)
        else:
            cf_loc = data_dir

        with open(cf_loc, "r") as f:
            self.data = json.load(f)
        if size is not None:
            self.data = self.data[:size]

        print(f"Loaded dataset with {len(self)} elements")

    def set_data(self, data):
        self.data = data

    def __len__(self):
        return len(self.data)

    def __getitem__(self, item):
        return self.data[item]


class MultiCounterFactDataset(CounterFactDataset):
    def __init__(
        self, data_dir: str, size: typing.Optional[int] = None, *args, **kwargs
    ):
        super().__init__(data_dir, *args, multi=True, size=size, **kwargs)
