from scipy.stats import norm
import matplotlib.pyplot as plt
import numpy as np

def softmax(x):
    """Compute softmax values for each sets of scores in x."""
    e_x = np.exp(x - np.max(x))
    return e_x / e_x.sum()

mu_f = 0
mu_g = -1.849591
sigma = 1

a = [0, 0.5]
f = norm.pdf(a, loc=mu_f, scale=sigma) # pdf of each of number in a
g = norm.pdf(a, loc=mu_g, scale=sigma)
w_f = softmax(f) # softmax weight of each of number in a
w_g = softmax(g)

x = np.linspace(-4, 4, 100)
pdf_f = norm.pdf(x, loc=mu_f, scale=sigma)
pdf_g = norm.pdf(x, loc=mu_g, scale=sigma)
print(f"probability density of f: {f}")
print(f"probability density of g: {g}")
print(f"f(a1) - f(a2) = {f[0]-f[1]:.5}")
print(f"g(a1) - g(a2) = {g[0]-g[1]:.5}")
print(f"weight of f: {w_f}")
print(f"weight of g: {w_g}")

fig, ax1 = plt.subplots()
color= 'tab:black'
ax1.set_xlabel('action')
ax1.set_ylabel('density')
#ax1.tick_params(axis='y', labelcolor=color)

ax1.plot(x, pdf_f, alpha=0.5, label='target')
ax1.plot(x, pdf_g, alpha=0.5, label='predicted')
ax1.plot(a, f, 'r+', markersize=10, alpha=0.5, label="samples on target")
ax1.plot(a, g, 'bo', alpha=0.5, label="samples on predicted")

ax2=ax1.twinx()
color='tab:cyan'
ax2.set_ylabel('softmax weight', color=color)
ax2.plot(a, w_f, 'cv', alpha=0.5, label="target weights")
ax2.plot(a, w_g, 'cD', alpha=0.5, label="predicted weights")
ax2.tick_params(axis='y', labelcolor=color)

ax1.legend(loc='upper left')
ax2.legend(loc='upper right')
fig.tight_layout()
plt.show()
