import glob
from scipy.io import loadmat
import matplotlib.pyplot as plt

file_list = glob.glob('./log/*/*/*/logs.mat')
file_list = [name for name in file_list if '12:55:54' in name or '14:15:36' in name]
print("file list is {}".format(file_list))
mode = 'all' # full, all
#mode = 'test'  # full, all
legend_label = []

colormap = plt.cm.gist_ncar

fig, ax = plt.subplots()
#plt.gca().set_color_cycle([colormap(i) for i in np.linspace(0, 0.9, len(file_list))])
import cycler
import numpy as np
plt.rcParams['axes.prop_cycle']= cycler.cycler('color', [colormap(i) for i in np.linspace(0, 0.9, len(file_list))])

for name in file_list:
    mat_data = loadmat(name)
    episode_iter_id = mat_data["episode_iter_id"]
    test_returns = mat_data['test_returns']
    test_returns_std_err = mat_data["test_returns_std_err"]
    print(name + '\n')
    #print(test_returns)
    #print('\n\n')
    #import pdb; pdb.set_trace()
    if mode in ['test', 'all']:
        # testing
        ax.plot(episode_iter_id[0], test_returns.reshape([-1]))
        ax.fill_between(episode_iter_id[0], test_returns[0] + test_returns_std_err[0], test_returns[0] - test_returns_std_err[0], alpha=0.2)
        legend_label.append('test_' + name.split('/')[2])
        # training
        returns = mat_data['returns']
        ax.plot(episode_iter_id[0], returns.reshape([-1]), '--')
        legend_label.append('train_' + name.split('/')[2])
ax.set_xlabel('Episode')
ax.set_ylabel('Returns')
plt.legend(legend_label)
plt.show()
