#!/bin/bash

TRAIN="data/listops/D10-A10-l500-L600-5k-2k-2k/basic_train.tsv"
VAL="data/listops/D10-A10-l500-L600-5k-2k-2k/basic_val.tsv"
NEMB=64
NHEAD=1
NBLOCK=10
DR=0.01
BSZ=25
NEPOCHS=200
ODIR="results/listops"
CDIR="checkpoints/listops"

MASK=$1
MSIZE=$2
NGTK=$3
MLPA=$4
TRIAL=$5
LR=$6
DLR=$7

NAME="LISTOPS-${MASK}-${MSIZE}-${NGTK}-${MLPA}-${TRIAL}-${LR}-${DLR}"
echo $NAME

SEED=$(sed "${TRIAL}q;d" random_seeds)
echo "RUNNING REP ${TRIAL}/10 WITH SEED ${SEED} ..."
python listops.py \
       -T ${TRAIN} -V ${VAL} --nocls \
       -e ${NEMB} -m ${NEMB} -B ${NBLOCK} -H ${NHEAD} \
       -M ${MASK} --mask_size ${MSIZE} --ngtk ${NGTK} \
       --mlpa ${MLPA} \
       -d ${DR} -l ${LR} -D ${DLR} -b ${BSZ} -E ${NEPOCHS} \
       --seed ${SEED} \
       -O ${ODIR} -C ${CDIR} \
       --adam
echo "REP ${TRIAL}/10 completed"
