#!/usr/bin/env python

import argparse
import os
import sys
from itertools import product
from pprint import pprint

import numpy as np
import pandas as pd

def wratio(ds, c1, beta, c2s, mult=2):
  assert beta == -1
  dens = ds * c2s
  lvals = mult * (1.0 + (1.0 / dens))
  vals = c1 + ((1.0 / ds) * np.log(lvals))
  return vals

def xratio(ds, c1, beta, c2s):
  assert beta >= 1
  # NOTE: Assuming 2 * gamma * \xi^2 = delta_s
  dens = ds * c2s
  lvals = ds * (1 + beta) * (1.0 + (1.0 / dens))
  lvals += beta
  vals = c1 + ((1.0 / ds) * np.log(lvals)) - ((1 / ds) * np.log(ds + 1))
  return vals

ListOps = [[8.61, 18.5, 29.4], [3.51, 6.74, 9.67], [0.016, 0.005, 0.002], [1, 3, 15] ]
Parity = [[8.30, 10.1, 11.2], [2.31, 3.13, 3.78], [0.062, 0.022, 0.011], [8, 13, 16] ]
EvenPairs = [[2.03, 4.73, 9.44], [1.03, 2.84, 5.50], [0.009, 0.003, 0.002], [6, 17, 26] ]
MissingDup = [[4.63, 9.25, 17.1], [2.36, 4.25, 4.88], [0.018, 0.006, 0.003], [7, 15, 21] ]

for D in [ListOps, Parity, EvenPairs, MissingDup]:
  vals = np.array(D)
  print('D')
  for i in range(vals.shape[1]):
    col = vals[:, i]
    ds = col[0]
    c1 = col[1] / ds
    c2 = col[2] / ds
    print(f'- W: {wratio(ds, c1, -1, c2):.4f}')
    beta = col[3]
    print(f'- X: {xratio(ds, c1, beta, c2):.4f}')
    
