import networkx as nx

import sys

from decentralizepy.graphs.Graph import Graph


class RegularBad(Graph):
    """
    The class for generating a Regular topology

    """

    def __init__(self, n_procs, degree, seed=None):
        """
        Constructor. Generates a Ring graph

        Parameters
        ----------
        n_procs : int
            total number of nodes in the graph
        degree : int
            Neighbors of each node

        """
        super().__init__(n_procs)
        assert n_procs % 2 == 0
        G = nx.random_regular_graph(degree, n_procs//2, seed)
        adj = G.adjacency()
        for i, l in adj:
            self.adj_list[i] = set()  # new set
            for k in l:
                self.adj_list[i].add(k)

        print(self.adj_list)

        offset = n_procs//2
        adj = G.adjacency()
        for i, l in adj:
            self.adj_list[i + offset] = set()  # new set
            print("Adding edges to node", i + offset)
            for k in l:
                print("Adding edge ", k + offset)
                self.adj_list[i + offset].add(k + offset)

        print(self.adj_list)
        
        first_edge = next(iter(self.adj_list[0]))
        second_edge = next(iter(self.adj_list[offset]))
        self.adj_list[0].remove(first_edge)
        self.adj_list[first_edge].remove(0)

        self.adj_list[offset].remove(second_edge)
        self.adj_list[second_edge].remove(offset)

        self.adj_list[0].add(second_edge)
        self.adj_list[second_edge].add(0)

        self.adj_list[offset].add(first_edge)
        self.adj_list[first_edge].add(offset)
        
        if not nx.is_connected(G):
            self.connect_graph()
