from random import Random
import json
import sys


def main(fanout, total_nodes, rounds, all_seeds):
    distribution = dict()

    for i in all_seeds:
        distribution[i] = dict()
        for j in range(total_nodes):
            distribution[i][j] = dict()
            for k in range(rounds):
                distribution[i][j][k] = 0


    for i in all_seeds:
        for j in range(total_nodes):
            my_neighbors = [x for x in range(total_nodes) if x != j]
            rng = Random()
            rng.seed(i+j)
            for k in range(rounds):
                this_round = set(rng.sample(my_neighbors, fanout))
                for l in this_round:
                    distribution[i][l][k] += 1
    
    return distribution


if __name__ == "__main__":
    fanout = 7
    total_nodes = 100
    rounds = 5000
    all_seeds = [x for x in range(90,95)]
    distribution = main(fanout, total_nodes, rounds, all_seeds)
    # write distribution to json file
    with open('/mnt/nfs/shared/rT-f{}-n{}-i{}in-dist.json'.format(fanout, total_nodes, rounds), 'w') as fp:
        json.dump(distribution, fp)
    
    sys.exit()

    fanout = 10
    total_nodes = 1000
    rounds = 5000
    all_seeds = [x for x in range(90,95)]
    distribution = main(fanout, total_nodes, rounds, all_seeds)
    # write distribution to json file
    with open('/mnt/nfs/shared/rT-f{}-n{}-i{}in-dist.json'.format(fanout, total_nodes, rounds), 'w') as fp:
        json.dump(distribution, fp)


    

    fanout = 13
    total_nodes = 10000
    rounds = 5000
    all_seeds = [x for x in range(90,95)]
    distribution = main(fanout, total_nodes, rounds, all_seeds)
    # write distribution to json file
    with open('/mnt/nfs/shared/rT-f{}-n{}-i{}in-dist.json'.format(fanout, total_nodes, rounds), 'w') as fp:
        json.dump(distribution, fp)

