import os
import sys
from pathlib import Path
import shutil

if __name__ == "__main__":
    assert len(sys.argv) == 2
    directoryPath = sys.argv[1]
    # 1: directory of folders
    machine_counter=0
    folders = [x for x in os.listdir(directoryPath) if os.path.isdir(os.path.join(directoryPath, x))]
    for folder in folders:
        inner_path = os.path.join(directoryPath, folder)
        folderName, number = folder.split("_")
        number = int(number)
        inner_most_folders = [x for x in os.listdir(inner_path) if os.path.isdir(os.path.join(inner_path, x)) and x.startswith("machine")]
        for folders_to_copy in inner_most_folders:
            old_folder_path = os.path.join(inner_path, folders_to_copy)
            print("Processing1 folder "+ inner_path)
            new_folder_name = "machine" + str(machine_counter)
            machine_counter += 1
            new_folder_path = os.path.join(directoryPath, new_folder_name)
            print("Moving " + old_folder_path + "to " + new_folder_path)
            shutil.move(old_folder_path, new_folder_path)
        print("Removing " + inner_path)
        shutil.rmtree(inner_path)
