from abc import ABC


class RawUnitBase(ABC):

    @classmethod
    def extract(
        cls, encoder, midi_dir, midi_path,
        pos_info, bars_positions, bars_chords, bars_insts, bar_begin, bar_end, **kwargs
    ):
        raise NotImplementedError

    @classmethod
    def repr_value(cls, value):
        return value

    @classmethod
    def derepr_value(cls, rep_value):
        return rep_value


class RawUnitForExistedValue(RawUnitBase):
    @classmethod
    def get_fields(cls):
        raise NotImplementedError

    @classmethod
    def extract(
        cls, encoder, midi_dir, midi_path,
        pos_info, bars_positions, bars_chords, bars_insts, bar_begin, bar_end, **kwargs
    ):
        fields = cls.get_fields()
        if isinstance(fields, str):
            fields = (fields,)

        r = {}
        for field in fields:
            r[field] = kwargs[field] if field in kwargs else None
        return r
