import os

import numpy as np
import random
import shutil
from tqdm import tqdm
def seed_everything(seed):
    np.random.seed(seed)
    random.seed(seed)

if __name__ == "__main__":
    gen_path = "../generation/0429/stage2/A2M_mask_v5-xl-v3.1_20230318-node16-checkpoint_best"
    command_name = "e2e_0425_stage1/topk15-t1.0-ngram0"
    tgt_path = "../generation//0505/A2M_mask_v5-xl-v3.1_20230318-node16-checkpoint_best"

    indexes = []
    for index in os.listdir(f"../generation/0505/A2M_mask_v5-1billion-v3.3_20230405-checkpoint_1_60000/{command_name}"):
        if "." not in index:
            indexes.append(index)
    os.makedirs(tgt_path + f'/{command_name}', exist_ok=True)
    for index in tqdm(indexes):
        shutil.copytree(gen_path + f"/{command_name}/{index}", tgt_path + f'/{command_name}/{index}')
