start=${3}
end=${4}
#input args
model_size=${1}
k=${2}
command_name="subj_stage1"
need_num=100

temp=1.0
ngram=0
simple=1

if [ "${model_size}" = "std" ];
then
  datasets_name="v3.1_20230318/small_12w"
  checkpoint_name="checkpoint_best"
  BATCH_SIZE=24

elif [ "${model_size}" = "large" ];
then
  datasets_name="v3.1_20230318"
  checkpoint_name="checkpoint_best"
  BATCH_SIZE=24
elif [ "${model_size}" = "xl" ];
then
  datasets_name="v3.1_20230318"
  checkpoint_name="checkpoint_best"
  BATCH_SIZE=24
else
  echo "Error model size for ${model_size}!"
  exit 1
fi
# models parameters


device=0
date="0406"
mkdir -p "log/${date}/${command_name}"
model_name="A2M_mask_v5-${model_size}-v3.1_20230318-node16"



# models parameters
DATA_DIR="../../Text2Music_data/${datasets_name}"

checkpoint_path="../checkpoints/${date}/${model_name}/${checkpoint_name}.pt"


ctrl_command_path="../../Text2Music_data/human_input/0313/${command_name}.bin"
save_root="../generation/${date}/${model_name}-${checkpoint_name}-0418/${command_name}/topk${k}-t${temp}-ngram${ngram}"


mkdir -p ${save_root}

export CUDA_VISIBLE_DEVICES=$device

echo "generating from ${checkpoint_path}"
echo "save to ${save_root}"

cd Attri2Music_mask_v5

python -u interactive_dict_v5.py \
${DATA_DIR}/data-bin \
--task language_modeling_control \
--path $checkpoint_path \
--ctrl_command_path $ctrl_command_path \
--save_root $save_root \
--need_num ${need_num} \
--start ${start} \
--end ${end} \
--max-len-b 5866 \
--min-len 512 \
--sampling \
--beam 1 \
--sampling-topk ${k} \
--temperature ${temp} \
--no-repeat-ngram-size ${ngram} \
--buffer-size ${BATCH_SIZE} \
--batch-size ${BATCH_SIZE}  > ../log/${date}/${command_name}/${model_name}_simple${simple}-k${k}-s${start}-e${end}.log 2>&1

