from minigrid.core.world_object import *
class LabeledGoal(Goal):
    """
    A goal object with an additional attribute to specify if it's the true goal.
    """

    def __init__(self, is_true_goal: bool, color: str = "green"):
        """
        Initialize the LabeledGoal.

        Args:
            is_true_goal (bool): Whether this goal is the true goal.
            color (str): The color of the goal.
        """
        super().__init__(color=color)
        self.is_true_goal = is_true_goal


    def __str__(self):
        return f"LabeledGoal(true={self.is_true_goal}, color={self.color})"
