# This is the supplementary code demo for ICLR 2026 submission with ID 16583

# Demo 1: Active Reconstruction Results (Table 1 in the main paper)

This code demo contains the Next-Best-View images and poses selected by our active reconstruction algorithm, and the 3DGS training script to reproduce results on Blender dataset. 

## Installation 

Download this anonymous repository. 

We suggest create environment with conda: 

```shell
conda create --name active python=3.8.18
conda activate active
# install requirements
pip install --user --no-cache-dir -r requirements.txt # if failed try looking for missing package version in requirements_all.txt
```

And setup gaussian splatting backend: 

```shell
# install rasterizer
cd models/gaussian_splatting/submodules/diff-gaussian-rasterization-depth
pip install -e --user .
# install simple-knn
cd ../simple-knn
pip install -e --user .
```

Please get the nerf-synthetic dataset test image files from https://drive.google.com/file/d/1OsiBs2udl32-1CqTXCitmov4NQCYdA9g/view

Add place them under data folder: 
```
iccv25activedemo
│
├──data
│   ├──── images
│   │
│   ├──── nbvposes
│   │
│   ├──── nerf_synthetic
│             ├──── drums
│             ├──── lego
│             ├────  .
│             ├────  .
│             └────  .
```


## Training with selected next-best-views

```python
python mp_launch.py --config configs/activegs_tenviews.yaml --gpu 0,1 --test --train
```

The results can be found in "exp" folder. 

# Demo 2: The consistent region partition result mesh files (Figure 3 & 4 in main paper)

The mesh with after consistent region partition can be found in folder "partition_results". 

The mesh with regions indicated by different vertex color demonstrates the seperation of object surface with different visibility features (see Figure 3 in main paper). 
