# bifrost-1

## Install Packages 

```
pip install -r multiflow_requirements.txt
```

## Train MLLM Vision Generation Branch

```
bash scripts/train.sh
```



## Train Latent ControlNet 

```
accelerate launch train_controlnet_flux.py \
    --pretrained_model_name_or_path="black-forest-labs/FLUX.1-dev" \
    --dataset_name=$DATAPATH \
    --conditioning_image_column=conditioning_image \
    --image_column=image \
    --caption_column=text \
    --output_dir=$OUTPUT_DIR \
    --mixed_precision="bf16" \
    --resolution=512 \
    --learning_rate=1e-5 \
    --max_train_steps=1000000 \
    --validation_steps=1000000 \
    --checkpointing_steps=500 \
    --train_batch_size=6 \
    --gradient_accumulation_steps=1 \
    --report_to="wandb" \
    --gradient_checkpointing \
    --num_double_layers=4 \
    --num_single_layers=1 \
    --seed=42 \
    --allow_tf32 \
    --cond_dropout_prob 0.1 \
    --path_prefix $PATH_PREFIX
```


## Inference 
```
python inference.py
```