%% 

function [] = dzoo_DRR_call() 
iter = 300;
epoch = [2 4 8 16 32 64 128];
epoch_true = [2 6 14 30 62 126 254];
set(gca, 'FontSize',14);
[~,p_0] = dzoo_DRR(0,iter);
[~,p_1] = dzoo_DRR(1,iter);
[~,p_2] = dzoo_DRR(2,iter);
[~,e_1] = dzoo_DRR_epoch(1,epoch);
[~,e_2] = dzoo_DRR_epoch(2,epoch);
e_1_aug = draw_a_line(e_1,epoch_true,iter,50);
e_2_aug = draw_a_line(e_2,epoch_true,iter,50);
h0 = line_fewer_markers( 1:iter,max(p_0), 10,'o-m','MarkerSize', 7, 'linewidth', 2);
h1 = line_fewer_markers( 1:iter,max(p_1), 10,'^-b','MarkerSize', 7, 'linewidth', 2);
h2 = line_fewer_markers( 1:iter,max(p_2), 10,'v-g','MarkerSize', 7, 'linewidth', 2);
he1 = line_fewer_markers( 1:iter,max(e_1_aug')', 10,'p-r','MarkerSize', 7, 'linewidth', 2);
he2 = line_fewer_markers( 1:iter,max(e_2_aug')', 10,'h-c','MarkerSize', 7, 'linewidth', 2);
legend([h0 h1 h2 he1 he2],...
     'gradient method',...
     'one-point MAZOPA',...
     'two-point MAZOPA',...
     'MS one-point MAZOPA',...
     'MS two-point MAZOPA')   
grid on;
xlabel('Iteration number T');
ylabel('Function Error');
set(gca, 'YScale', 'log');

