%% 

function [x_err,f_err] = dzoo_DRR(g_or_zo,iter)

%
d = 10;        
n = 50;        
lambda = 1/2;  

% 
threshold = 0.2800;
rand('state',100009);
xy = rand(n,2);

angle = 10*pi/180;
Rotate = [ cos(angle) sin(angle); -sin(angle) cos(angle) ];
xy = (Rotate*xy')';

Dist = zeros(n,n);
for i=1:(n-1);
    for j=i+1:n;
        Dist(i,j) = norm( xy(i,:) - xy(j,:) );
    end;
end;
Dist = Dist + Dist';
Ad = Dist < threshold;
Ad = Ad - eye(n);
m_edge = sum(sum(Ad))/2;

% 
A = zeros(n,m_edge);
l = 0;
for i=1:(n-1);
    for j=i+1:n;
        if Ad(i,j)>0.5
            l = l + 1;
            A(i,l) =  1;
            A(j,l) = -1;
        end;
    end;
end;
A = sparse(A);

% 
[ weight_m ]  = max_deg_dzoo(A);

% 
figure(1), clf
gplot(Ad,xy);
hold on;
plot(xy(:,1), xy(:,2), 'bo','LineWidth',5, 'MarkerSize',3);
axis([0.00 1.20 -0.15 1.00]);
axis off; 
hold off;

%
rng(4,'twister');    
pro_A = randn(d,n);  
pro_y = zeros(d,1);
for i = 1 : (d/2)
    pro_y(i) = 1;
end

rng(7,'twister');   
pro_b = rand(n,1);

% use 'cvx' to find the optimal solution
cvx_begin
variable x_min(d);
expression f_obj(1);
f_obj = (1/2)*x_min'*(pro_A*pro_A')*x_min + (1/2)*(pro_b'*pro_b) +...
    n*lambda*(x_min'*x_min) - (pro_A*pro_b)'*x_min;
minimize( f_obj );
subject to
norm(x_min,1) <= 3/4;
cvx_end

f_min = cvx_optval;  % optimal value of LP
fprintf(1,'Optimal value of LP is %0.4f.\n\n',f_min);

% 
rng(1,'twister');
x_state = ones(d,n)/d;
x_state_avg = zeros(d,n);       
x_err = zeros(n,iter);         
f_err = zeros(n,iter);          
grad = zeros(d,n);             
zo_one = zeros(d,n);            
zo_two = zeros(d,n);            

% 
csg = 5;
cs1 = 5;
cs2 = 5;
sg = zeros(iter,1);
s1 = zeros(iter,1);
s2 = zeros(iter,1);
for  k = 1 : iter
    sg(k) = csg/k;       
    s1(k) = cs1/k;       
    s2(k) = cs2/k;    
end
ep1 = zeros(iter,1);
ep2 = zeros(iter,1);
cep1 = 1e-2;
cep2 = 1e-2;
for i = 1 : iter
    ep1(i) = cep1/i;
    ep2(i) = cep2/i;
end


%
for j = 1 : n
    x_err(j,1) = norm(x_state(:,j)-x_min,2);
    f_err(j,1) = f_err(j,1) +(1/2)*x_state(:,j)'*(pro_A*pro_A')*x_state(:,j)...
        + (1/2)*(pro_b'*pro_b) + n*lambda*(x_state(:,j)'*x_state(:,j))...
        - (pro_A*pro_b)'*x_state(:,j);
    f_err(j,1) = f_err(j,1) - f_min;
end


for t = 2 : iter
    for j = 1 : n
        if g_or_zo == 0
            % 
            grad(:,j) = ( pro_A(:,j)'*x_state(:,j) - pro_b(j) )*pro_A(:,j) +...
                2*lambda*x_state(:,j);
            x_state(:,j) = x_state(:,j) - sg(t)*grad(:,j);
        elseif g_or_zo == 1
            % 
            rand('state',sum(100*clock));
            rand_vec = rand(d,1);
            rand_vec = rand_vec./norm(rand_vec,2); 
            zo_one(:,j) = ( (1/2)*( pro_A(:,j)'*(x_state(:,j)+ep1(t-1)*rand_vec) - pro_b(j) )^2+...
                lambda*norm((x_state(:,j)+ep1(t-1)*rand_vec),2)^2 )*d*rand_vec/ep1(t-1);
            x_state(:,j) = x_state(:,j) - s1(t)*zo_one(:,j);
        else
            % 
            rand('state',sum(100*clock));
            rand_vec = rand(d,1);
            rand_vec = rand_vec./norm(rand_vec,2);   
            zo_two(:,j) = ( ( (1/2)*( pro_A(:,j)'*(x_state(:,j)+ep2(t)*rand_vec) - pro_b(j) )^2+...
                lambda*norm((x_state(:,j)+ep2(t)*rand_vec),2)^2 ) -...
                ( (1/2)*( pro_A(:,j)'*(x_state(:,j)-ep2(t)*rand_vec) - pro_b(j) )^2+...
                lambda*norm((x_state(:,j)-ep2(t)*rand_vec),2)^2 ) )*d*rand_vec/(2*ep2(t));
            x_state(:,j) = x_state(:,j) - s2(t)*zo_two(:,j);
        end
    end

    x_state = x_state*weight_m';
    
    for h = 1 : n
        x_state(:,h) = proj_simplex(x_state(:,h));
    end
    for s = 1 : n
        x_state_avg(:,s) = ((t-1)/t)*x_state_avg(:,s) +...
            (1/t)*x_state(:,s);
        x_err(s,t) = norm(x_state_avg(:,s)-x_min,2)^2;      
        f_err(s,t) = f_err(s,t) +...
            (1/2)*x_state_avg(:,s)'*(pro_A*pro_A')*x_state_avg(:,s) +...
            (1/2)*(pro_b'*pro_b) + n*lambda*(x_state_avg(:,s)'*x_state_avg(:,s))-...
            (pro_A*pro_b)'*x_state_avg(:,s);       
        f_err(s,t) = f_err(s,t) - f_min;
    end
end









