%% 

function [x_err_epoch,f_err_epoch] = dzoo_DRR_epoch(one_or_two,epoch)
n = 50;      
d = 4;
lambda = 1/2;
R = 1/2; 
f_err_epoch = zeros(length(epoch),n);
x_err_epoch = zeros(length(epoch),n);
ep_epoch_1 = 1e-6;
ep_epoch_2 = 1e-3;
step_epoch_1 = .1;
step_epoch_2 = 10;

% 
threshold = 0.2800;
rand('state',100009);
xy = rand(n,2);

angle = 10*pi/180;
Rotate = [ cos(angle) sin(angle); -sin(angle) cos(angle) ];
xy = (Rotate*xy')';

Dist = zeros(n,n);
for i=1:(n-1);
    for j=i+1:n;
        Dist(i,j) = norm( xy(i,:) - xy(j,:) );
    end;
end;
Dist = Dist + Dist';
Ad = Dist < threshold;
Ad = Ad - eye(n);
m_edge = sum(sum(Ad))/2;

%
A = zeros(n,m_edge);
l = 0;
for i=1:(n-1);
    for j=i+1:n;
        if Ad(i,j)>0.5
            l = l + 1;
            A(i,l) =  1;
            A(j,l) = -1;
        end;
    end;
end;
A = sparse(A);


% 
[ weight_m ]  = max_deg_dzoo(A);

% 
rng(4,'twister');   
pro_A = randn(d,n);   
pro_y = zeros(d,1);
for i = 1 : (d/2)
    pro_y(i) = 1;
end
rng(7,'twister');   
pro_b = rand(n,1);


% 
cvx_begin
variable x_min(d);
expression f_obj(1);
f_obj = (1/2)*x_min'*(pro_A*pro_A')*x_min + (1/2)*(pro_b'*pro_b) +...
    n*lambda*(x_min'*x_min) - (pro_A*pro_b)'*x_min;
minimize( f_obj );
subject to
norm(x_min,1) <= 3/4;
cvx_end

f_min = cvx_optval;  % optimal value of LP
fprintf(1,'Optimal value of LP is %0.4f.\n\n',f_min);

%
rng(1,'twister');
x_state = ones(d,n)/d;
zo_one = zeros(d,n);         
zo_two = zeros(d,n);   

% 
for k_ep = 1 : length(epoch)
    x_state_all = zeros(d,n,epoch(k_ep));
    x_state_all(:,:,1) = x_state;
    for t = 1 : epoch(k_ep)-1
        if one_or_two == 1
            for j = 1 : n
                rand('state',sum(100*clock));
                rand_vec = rand(d,1);
                rand_vec = rand_vec./norm(rand_vec,2);   
                zo_one(:,j) = ( (1/2)*( pro_A(:,j)'*(x_state(:,j)+ep_epoch_1*rand_vec) - pro_b(j) )^2+...
                    lambda*norm((x_state(:,j)+ep_epoch_1*rand_vec),2)^2 )*d*rand_vec/ep_epoch_1;
                x_state(:,j) = x_state(:,j) - step_epoch_1*zo_one(:,j);
            end
        else
            for j = 1 : n
                rand('state',sum(100*clock));
                rand_vec = rand(d,1);
                rand_vec = rand_vec./norm(rand_vec,2);  
                zo_two(:,j) = ( ( (1/2)*( pro_A(:,j)'*(x_state(:,j)+ep_epoch_2*rand_vec) - pro_b(j) )^2+...
                    lambda*norm((x_state(:,j)+ep_epoch_2*rand_vec),2)^2 ) -...
                    ( (1/2)*( pro_A(:,j)'*(x_state(:,j)-ep_epoch_2*rand_vec) - pro_b(j) )^2+...
                    lambda*norm((x_state(:,j)-ep_epoch_2*rand_vec),2)^2 ) )*d*rand_vec/(2*ep_epoch_2);
                x_state(:,j) = x_state(:,j) - step_epoch_2*zo_two(:,j);
            end
        end
        x_state = x_state*weight_m';
        for p = 1 : n
            x_state(:,p) = ( R/max(norm(x_state(:,p)),R) )*x_state(:,p);
        end
        x_state_all(:,:,t+1) = x_state;
    end
    x_state_avg = zeros(d,n);
    for h = 1 : epoch(k_ep)
        x_state_avg = x_state_avg + x_state_all(:,:,h);
    end
    x_state_avg = (1/epoch(k_ep))*x_state_avg;
    
    for s = 1 : n
        x_state(:,s) = proj_simplex(x_state_avg(:,s));
        x_err_epoch(k_ep,s) = norm(x_state(:,s)-x_min,2)^2;
        f_err_epoch(k_ep,s) = f_err_epoch(k_ep,s) +...
            (1/2)*x_state(:,s)'*(pro_A*pro_A')*x_state(:,s) +...
            (1/2)*(pro_b'*pro_b) + n*lambda*(x_state(:,s)'*x_state(:,s))-...
            (pro_A*pro_b)'*x_state(:,s);      
        f_err_epoch(k_ep,s) = f_err_epoch(k_ep,s) - f_min;
    end
    step_epoch_1 = step_epoch_1/4;
    step_epoch_2 = step_epoch_2/4;
    ep_epoch_1 = ep_epoch_1/6;
    ep_epoch_2 = ep_epoch_2/6;
end
