# SpaceSet
SpaceSet: A Large-scale Realistic Space-based Image Dataset for Space Situational Awareness


## Repository Overview

This repository provides the SpaceSet dataset, designed to advance research in Space Situational Awareness (SSA). SpaceSet offers realistic space-based images generated with accurate space orbit dynamics and a physical camera model, suitable for developing advanced SSA techniques. The dataset is split into three subsets: SpaceSet-100, SpaceSet-5000, and SpaceSet-full, catering to various image processing applications. This codebase is still under construction. Comments, issues, contributions, and collaborations are all welcomed!

## Data

SpaceSet provides a comprehensive and realistic space-based image dataset designed to advance research in Space Situational Awareness (SSA). The dataset includes high-resolution images of resident space objects (RSOs) captured from various orbits. The datasets and their download links will be provided later.

Our codebase accesses the datasets from ./data/ and benchmark codes from ./codes/ by default.

```plaintext
├── ...
├── assets                           
├── data
│   ├── SpaceSet-100                 # SpaceSet-100 demo dataset
│   │   ├── images                   # tiff image data
│   │   │   ├── *.tiff               # tiff format image files
│   │   │   └── *.csv                # csv format data files
│   │   ├── labels                   # class and bounding box information
│   │   │   └── *.txt                # txt files containing class and bounding box information
│   ├── SpaceSet-5000                # SpaceSet-5000 demo dataset
│   │   ├── images                   # tiff image data
│   │   │   ├── *.tiff               # tiff format image files
│   │   │   └── *.csv                # csv format data files
│   │   ├── labels                   # class and bounding box information
│   │   │   └── *.txt                # txt files containing class and bounding box information
│   ├── SpaceSet-full                # SpaceSet-full demo dataset
│   │   ├── images                   # tiff image data
│   │   │   ├── *.tiff               # tiff format image files
│   │   │   └── *.csv                # csv format data files
│   │   ├── labels                   # class and bounding box information
│   │   │   └── *.txt                # txt files containing class and bounding box information
├── codes
│   ├── scripts                      # data preprocessing and benchmark implementation code
│   │   └── *.py                     # Python script files
│   ├── ultralytics                  # modified YOLOv8 code (integrated with YOLOv10)
│   │   └── *.py                     # Python script files
├── requirement.txt                  # Python libraries required to run the program
├── README.md                        # project introduction and usage instructions
├── ...

```

## Training and evaluation scripts

We provide training and evaluation scripts for all the methods we support in [scripts folder](./codes/scripts).

## Supported Object Detection Benchmarks

We compare the detection results of three object detection models: YOLOv5, YOLOv8, and YOLOv10. Each model is evaluated with five parameter sizes: n, s, m, l, and x.

- **YOLOv5** [GitHub](https://github.com/ultralytics/yolov5): YOLOv5, developed by Ultralytics, is a highly popular and efficient object detection model known for its speed and accuracy. It supports various tasks including object detection, instance segmentation, and more.

- **YOLOv8** [GitHub](https://github.com/ultralytics/ultralytics): YOLOv8 is an advanced version of YOLOv5, offering improved performance and new features. It continues to build on the strengths of its predecessor with enhanced detection capabilities and flexibility for different applications.

- **YOLOv10** [GitHub](https://github.com/THU-MIG/yolov10): YOLOv10, the latest in the YOLO series, introduces significant architectural improvements and optimizations. It is designed to deliver superior detection results with higher efficiency and accuracy compared to earlier versions.

## Supported Object Tracking Benchmarks
Two methods were tested: Bytetrack and BoT-SORT. These methods were adapted to improve their performance for space-based applications. For similarity calculations, Intersection over Union (IoU) and Euclidean distance were used. Additionally, BoT-SORT variants incorporated different global motion compensation algorithms and feature-based similarity calculations.

- **Bytetrack** [GitHub](https://github.com/ifzhang/ByteTrack): Bytetrack is a multiple object tracking method that can use either IoU similarity calculations or Euclidean distance similarity calculations for tracking accuracy.

- **BoT-SORT** [GitHub](https://github.com/NirAharon/BoT-SORT): BoT-SORT is a versatile multiple object tracking method that supports several similarity calculation options:
  - **IoU Similarity Calculation**
  - **Euclidean Distance Similarity Calculation**
  - **Feature Similarity Calculation**: This can be done using features from YOLO, HOG, or SIFT.

  Additionally, BoT-SORT can incorporate various global motion compensation (GMC) methods, including:
  - ECC (Enhanced Correlation Coefficient)
  - ORB (Oriented FAST and Rotated BRIEF)
  - SIFT (Scale-Invariant Feature Transform)
  - Sparse Optical Flow
 
## Get Started

### Installation

To install the SpaceSet project, you need to clone the repository and install the required dependencies manually. Follow the steps below:

1. **Clone the repository:**
    ```bash
    cd SpaceSet
    ```
2. **Install the required dependencies:**
    ```bash
    pip install -r requirements.txt
    ```
    
### Experimental Environment
Our experiments were conducted in the following environment:
- **Operating System:** Ubuntu 22.04
- **Conda Version:** 23.7.4
- **PyTorch Version:** 2.1.2
- **Python Version:** 3.11.7
All the required libraries are included in the `requirements.txt` file.

### Implementation
#### Setting Up the Environment
First, ensure that the `ultralytics` directory is added to the `PYTHONPATH`. This can be done by running the following command in your terminal:
```bash
export PYTHONPATH=$PYTHONPATH:/path/to/SpaceSet/codes/ultralytics
```
Replace `/path/to/SpaceSet/codes/ultralytics` with the actual path to the `ultralytics` directory.

#### Running the Code
To run the code, simply execute the following command:
```bash
python ./codes/scripts/main.py
```
All parameters are specified in `./ultralytics/cfg/default.yaml` and `./ultralytics/cfg/botsort.yaml`, including all adjustable benchmark methods and corresponding comments.
Ensure to update all path configurations in the default.yaml file to match your environment.








