import numpy as np
import matplotlib.pyplot as plt

# In a for loop:
#   Create the name of the file based on the parameter
#   Load the file
#   Plot the data

env_name = 'pinball'
aux_type = 'None'
policy_name = 'main'
aux_task_number = 0
alphas = [0.001]
hidden_sizes = [256]
buffer_capacities = [40000, 60000, 100000, 1000000]


def moving_average(x, w):
    return np.convolve(x, np.ones(w), 'valid') / w


# num_steps_over_runs_aux_type_None_policy_main_aux_num_0_rep_nonlinear_alpha_0.1_hidden_size_16.npy
for alpha in alphas:
    for hidden_size in hidden_sizes:
        # file_name = ('{}/num_steps_over_runs_aux_type_{}_policy_{}_aux_num_{}_rep_nonlinear_alpha_{}_hidden_size_{}'.
        #              format(env_name, aux_type, policy_name, aux_task_number, alpha, hidden_size))
        for buffer_capacity in buffer_capacities:
            file_name = ('{}/num_steps_over_runs_aux_type_{}_policy_{}_aux_num_{}_rep_nonlinear_alpha_{}_hidden_size_{}_buffer_capacity_{}'.
                         format(env_name, aux_type, policy_name, aux_task_number, alpha, hidden_size, buffer_capacity))
            num_steps_over_runs = np.load(f'../{file_name}.npy')
            window = 20
            smooth_num_steps_over_runs = np.zeros((num_steps_over_runs.shape[0], num_steps_over_runs.shape[1] - window + 1))
            for i in range(num_steps_over_runs.shape[0]):
                smooth_num_steps_over_runs[i, :] = moving_average(num_steps_over_runs[i, :], window)
            num_steps_over_runs = smooth_num_steps_over_runs
            mean_res = np.mean(num_steps_over_runs, axis=0)
            name = f'{alpha}+{hidden_size}+{buffer_capacity}'
            plt.plot(np.arange(num_steps_over_runs.shape[1]), mean_res, label = name)
plt.legend()
plt.show()
