import numpy as np

class TargetGenerator:
    def __init__(self, inital_target, seed):
        self.rng = np.random.RandomState(seed)
        self.target = inital_target
        self.value = inital_target
        self.constant_duration = self.rng.randint(100, 101)
        self.change_duration = 0
        self.slope = 0.0075
        self.state = "constant"
        self.constant_step = 0
        self.change_step = 0

    def update(self):
        if self.state == "constant":
            self.constant_step += 1
            if self.constant_step > self.constant_duration:
                self.state = "changing"
                self.constant_step = 0
                self.change_duration = 200#self.rng.randint(100, 200)
                self.change_direction = self.rng.choice(2) * 2 - 1
                self.target = self.value + self.slope * self.change_direction * self.change_duration
                while self.target < 1 or self.target > 2.5:
                    self.change_duration = 200#self.rng.randint(100, 200)
                    self.change_direction = self.rng.choice(2) * 2 - 1
                    self.target = self.value + self.slope * self.change_direction * self.change_duration
                print(self.target)
                self.value = self.value + self.slope * self.change_direction
                self.change_step = 0
        elif self.state == "changing":
            self.change_step += 1
            self.value = self.value + self.slope * self.change_direction
            if (self.change_direction == 1 and self.value >= self.target) or (self.change_direction == -1 and self.value <= self.target):
                self.change_step == 0
                self.constant_duration = self.rng.randint(100, 101)
                self.state = "constant"

# generator = TargetGenerator(1)
# num_steps = 250000
# list = np.zeros(num_steps)
# for i in range(num_steps):
#     generator.update()
#     list[i] = generator.value
#
# from matplotlib import pyplot as plt
# plt.plot(list)
# plt.savefig('test.pdf')
