from Environments.FourRoomsWorld import *
import numpy as np
from gym import core, spaces



class FourRoomsGridWolrdDoorKey(FourRoomGridWorld):
    def __init__(self):
        super(FourRoomsGridWolrdDoorKey, self).__init__()
        self._door_pos = (5, 2)
        self._key_pos = (0, 6)
        self.ACTION_PICKUP, self.ACTION_DROP, self.OPEN_DOOR = 4, 5, 6
        self.num_actions = 7
        self.action_space = spaces.Discrete(self.num_actions)
        self.carry_key = False
        self.door_open = False

    def reset(self):
        self._state = (0, 0)
        self.carry_key = False
        self.door_open = False
        return self.get_rep(*self._state)

    def get_rep(self, x, y):
        index = self.get_state_index(x, y)
        rep = np.zeros(self._grid.shape[0] ** 2 + 2)
        rep[index] = 1
        rep[self._grid.shape[0] ** 2] = 1 if self.carry_key else 0
        rep[self._grid.shape[0] ** 2 + 1] = 1 if self.door_open else 0
        return rep

    def _next(self, action, x, y):
        def move(current_x, current_y, next_x, next_y):
            if next_y < 0 or next_x < 0:
                return current_x, current_y
            if next_y >= self._max_col or next_x >= self._max_row:
                return current_x, current_y
            if self._grid[next_x, next_y] == BLOCK_WALL:
                return current_x, current_y
            if next_x == self._door_pos[0] and next_y == self._door_pos[1] and (self.door_open is False):
                return current_x, current_y
            return next_x, next_y

        switcher = {
            self.ACTION_DOWN: lambda pox_x, pos_y: move(pox_x, pos_y, pox_x, pos_y - 1),
            self.ACTION_RIGHT: lambda pox_x, pos_y: move(pox_x, pos_y, pox_x + 1, pos_y),
            self.ACTION_UP: lambda pox_x, pos_y: move(pox_x, y, pox_x, pos_y + 1),
            self.ACTION_LEFT: lambda pox_x, pos_y: move(pox_x, pos_y, pox_x - 1, pos_y),
        }

        if action == self.ACTION_PICKUP:
            if not self.carry_key:
                self.carry_key = True
            return x, y
        elif action == self.ACTION_DROP:
            if self.carry_key:
                self.carry_key = False
            return x, y
        elif action == self.OPEN_DOOR:
            if self.carry_key:
                self.door_open = True
            return x, y
        else:
            move_func = switcher.get(action)
            return move_func(x, y)