from Environments.FourRoomsWorld import FourRoomGridWorld
import numpy as np

class FourRoomsGridWolrdNoisy(FourRoomGridWorld):
    def __init__(self):
        super(FourRoomsGridWolrdNoisy, self).__init__()
        self.noise_percent = 0.01

    def get_rep(self, x, y):
        index = self.get_state_index(x, y)
        rep = np.zeros(self._grid.shape[0] ** 2)
        rep[index] = 1
        random_indices = np.random.choice(self._grid.shape[0] ** 2, int(np.ceil((self._grid.shape[0] ** 2)*self.noise_percent)), replace=False)
        rep[random_indices] = 1 - rep[random_indices]
        return rep

# class FourRoomsGridWolrdNoisy(FourRoomGridWorld):
#     def __init__(self):
#         super(FourRoomsGridWolrdNoisy, self).__init__()
#         self.noisy_bit_number = 50
#
#     def get_rep(self, x, y):
#         index = self.get_state_index(x, y)
#         rep = np.zeros(self._grid.shape[0] ** 2 + self.noisy_bit_number)
#         rep[index] = 1
#         rep[self._grid.shape[0] ** 2:] = np.random.binomial(1, 0.05, self.noisy_bit_number)
#         return rep