import sys
sys.path.append('.')

from matplotlib import pyplot as plt
import numpy as np

env_name = 'four_rooms'
aux_type = 'MSGT'

fig, ax = plt.subplots(figsize=(10,6))

colors = ['red', 'red', 'blue', 'blue']

aux_scores = np.load('{}/aux_scores_{}.npy'.format(env_name, aux_type))
num_auxiliary_tasks = aux_scores.shape[2]


for i in np.arange(num_auxiliary_tasks):
    ax.plot(np.mean(aux_scores[:, :, i], axis=0), color=colors[i])

ax.spines['right'].set_visible(False)
ax.spines['top'].set_visible(False)
plt.xticks(fontsize=40)
plt.yticks(fontsize=40)
ax.set_yticks((0, 10, 20, 30))
ax.set_xticks((0, 50, 100, 150, 200))
# ax.set_ylim((-1000, 1000))
plt.savefig('{}_aux_scores.pdf'.format(env_name))
