import sys
sys.path.append('.')

from matplotlib import pyplot as plt
from util.util import moving_average
import numpy as np


env_name = 'puddle_world'
fig, ax = plt.subplots(figsize=(10,6))

param_list = [
              {'aux_type': 'None', 'aux_num': 0, 'policy': 'main', 'color': 'orange', 'rep': 'nonlinear'},

    {'aux_type': 'random', 'policy': 'main', 'aux_num': 0, 'color': 'black', 'rep': 'nonlinear'},

    # {'aux_type': 'random_goal', 'policy': 'main', 'aux_num': 5, 'color': 'black', 'rep': 'nonlinear'},
    #
    #          {'aux_type': 'puddle_path', 'policy': 'main', 'aux_num': 4, 'color': 'red', 'rep': 'nonlinear'},

]

for param in param_list:
    num_steps_over_runs = np.load('{}/avg_reward_aux_type_{}_policy_{}_aux_num_{}_rep_{}.npy'.format
                                  (env_name, param['aux_type'], param['policy'], param['aux_num'], param['rep']))

    window = 10
    smooth_num_steps_over_runs = np.zeros((num_steps_over_runs.shape[0], num_steps_over_runs.shape[1] - window + 1))
    for i in range(num_steps_over_runs.shape[0]):
        smooth_num_steps_over_runs[i, :] = moving_average(num_steps_over_runs[i, :], window)
    num_steps_over_runs = smooth_num_steps_over_runs

    num_steps_over_runs_mean = np.mean(num_steps_over_runs, 0)
    num_steps_over_runs_se = np.std(num_steps_over_runs, 0) / np.sqrt(num_steps_over_runs.shape[0])

    ax.plot(num_steps_over_runs_mean, param['color'])
    ax.fill_between(np.arange(num_steps_over_runs_mean.shape[0]), num_steps_over_runs_mean - num_steps_over_runs_se/2,
                    num_steps_over_runs_mean + num_steps_over_runs_se/2, alpha = 0.5, color = param['color'])


# ax.set_ylim((-10000, 0))

ax.spines['right'].set_visible(False)
ax.spines['top'].set_visible(False)

# plt.xticks(fontsize=40)
# plt.yticks(fontsize=40)
plt.savefig('{}_avg_reward_{}.pdf'.format(env_name, param_list[-1]['aux_type']))
# print(stats.ttest_ind(num_steps_over_runs_mean, num_steps_over_runs_mean_aux))
