import sys
sys.path.append('.')

from matplotlib import pyplot as plt
from util.util import moving_average
import numpy as np


env_name = 'four_rooms'
fig, ax = plt.subplots(figsize=(10,6))

param_list = [
              {'aux_type': 'None',  'color': 'orange'},

              {'aux_type': 'MSGT', 'color': 'green'},

]

for param in param_list:
    stable_ranks = np.load('{}/stable_ranks_{}.npy'.format(env_name, param['aux_type']))

    stable_ranks_mean = np.mean(stable_ranks, 0)
    stable_ranks_se = np.std(stable_ranks, 0) / np.sqrt(stable_ranks.shape[0])

    ax.plot(stable_ranks_mean, param['color'])
    # ax.fill_between(np.arange(stable_ranks_mean.shape[0]), stable_ranks_mean - stable_ranks_se/2,
    #                 stable_ranks_mean + stable_ranks_se/2, alpha = 0.5, color = param['color'])



ax.spines['right'].set_visible(False)
ax.spines['top'].set_visible(False)


ax.set_xticks((0, 100, 200))
if env_name == 'maze':
    ax.set_xticks((0, 100, 200, 300))

plt.xticks(fontsize=40)
plt.yticks(fontsize=40)
plt.savefig('{}_stable_rank_{}.pdf'.format(env_name, param_list[-1]['aux_type']))
# print(stats.ttest_ind(num_steps_over_runs_mean, num_steps_over_runs_mean_aux))
