import json
import os

class Configuration:
    def __init__(self, json_path):
        self._path = json_path
        with open(self._path) as f:
            self._params = json.load(f)

    @property
    def env_name(self):
        return self._params['env_name']

    @property
    def learner_name(self):
        return self._params['learner_name']

    @property
    def net_type(self):
        return self._params['net_type']

    @property
    def buffer_capacity(self):
        return self._params['buffer_capacity']

    @property
    def buffer_batch_size(self):
        return self._params['buffer_batch_size']

    @property
    def hidden_size(self):
        return self._params['hidden_size']

    @property
    def target_net_update_frequency(self):
        return self._params['target_net_update_frequency']

    @property
    def input_size(self):
        return self._params['input_size']

    @property
    def gamma(self):
        return self._params['gamma']

    @property
    def num_episodes(self):
        return self._params['num_episodes']

    @property
    def max_steps(self):
        return self._params['max_steps']

    @property
    def episode_cutoff(self):
        return self._params['episode_cutoff']

    @property
    def max_episode(self):
        return self._params['max_episode']

    @property
    def obs_size(self):
        return self._params['obs_size']

    @property
    def epsilon_annealing(self):
        return self._params['epsilon_annealing']

    @property
    def epsilon(self):
        return self._params['epsilon']

    @property
    def replay_start_size(self):
        return self._params['replay_start_size']

    @property
    def num_replay(self):
        return self._params['num_replay']

    @property
    def layer_number(self):
        if 'layer_number' not in self._params.keys():
            return 2
        return self._params['layer_number']

    @property
    def cumulant_net_type(self):
        if 'cumulant_net_type' not in self._params.keys():
            return 'fully_connected'
        return self._params['cumulant_net_type']

    @property
    def HER_sample_state_constant(self):
        if 'HER_sample_state_constant' not in self._params.keys():
            return self._params['obs_size']
        return self._params['HER_sample_state_constant']

    @property
    def optimizer(self):
        if 'optimizer' not in self._params.keys():
            return 'RMSprop'
        return self._params['optimizer']

    @property
    def head_activation(self):
        if 'head_activation' not in self._params.keys():
            return 'tanh'
        return self._params['head_activation']

    @property
    def end_epsilon(self):
        if 'end_epsilon' not in self._params.keys():
            return 0.01
        return self._params['end_epsilon']
