from sklearn.ensemble import AdaBoostClassifier
import random

class BaggingMaj():
    def __init__(self, n_voting_classifiers, n_weak_classifiers, weak_classifier=None):
        self.n_voting_classifiers = n_voting_classifiers
        self.n_weak_classifiers = n_weak_classifiers
        self.hypotheses = [AdaBoostClassifier(estimator=weak_classifier, n_estimators=self.n_weak_classifiers, algorithm='SAMME')
                           for _ in range(self.n_voting_classifiers)]

    def fit(self, X, y):
        for i in range(self.n_voting_classifiers):
            idx = random.choices(range(len(X)), k=int(len(X)*0.95))
            self.hypotheses[i].fit(X[idx], y[idx])
            self.hypotheses[i].n_classes_ = 2 # If subsample has only one class, AdaBoostClassifier will throw an error

    def predict(self, X):
        return (sum([h.predict(X) for h in self.hypotheses]) > self.n_voting_classifiers//2)*1

    def score(self, X, y):
        return sum(self.predict(X) == y) / len(X)

