# Pre-training and evaluation in the family of 2D CDR equation dataset.

#### model hyperparameters
model="PDE_PFN"
nhid=512      # hidden dimension in en/decoder
nips=32       # 1/2 hidden dimension in transformer block
nlayers=16    # number of transformer layers
nhead=5       # number of heads in transformer layers
num_freqs=0   # number of fourier features
is_grid=0     # consider data as grid data or not
AGF_depth=15  # depth of the AGF
fixI=0        # 
dropout=0.2   # dropout rate

#### training hyperparameters
data="2D_cdr"               # dataset
PINN_ratio=100              # PINN ratio in pre-training model
epoch=100                   # epoch
total=1                     # model type
N_train=2187                # number of training sample
batch=27                    # batch number
lr=0.0005                   # learning rate
lr_decay=0.95               # learning rate decay
scheduler="warmup_linear"   # learning rate scheduler

#### training Hardware : GPU 
gpu=0

if [[ ! -d "logs/$model/$data" ]]; then
  mkdir -p -- "logs/$model/$data"
fi

# Pre-training
CUDA_VISIBLE_DEVICES=$gpu python -u Train_main.py\
    --beta_min 0.0     --beta_max 1.0    --beta_step 0.5\
    --beta_y_min 0.0   --beta_y_max 1.0\
    --nu_min 0.0       --nu_max 1.0      --nu_step 0.5\
    --nu_y_min 0.0     --nu_y_max 1.0\
    --rho_min 0.0      --rho_max 1.0     --rho_step 0.5\
    --epsilon_min 0.0  --epsilon_max 1.0 --epsilon_step 0.5\
    --theta_min 0.0    --theta_max 1.0   --theta_step 0.5\
    --model $model --data $data --numerical 0 --extrapolation 1 --total $total\
    --N_train_shot $N_train --lr $lr --lr_decay $lr_decay --scheduler $scheduler\
    --nhid $nhid --nlayers $nlayers --nips $nips --nhead $nhead --fixI $fixI\
    --num_freqs $num_freqs --AGF_depth $AGF_depth --is_grid $is_grid\
    --epoch $epoch --batch $batch --PINN_based_prior_ratio $PINN_ratio\
    > "./logs/$model/$data/train_PINN_nh$nhid"_nl"$nlayers"_nhd"$nhead"_nf"$num_freqs"_Ad"$AGF_depth"_"$lr"_"$scheduler.log"

# Test Seen coeff interpolation
CUDA_VISIBLE_DEVICES=$gpu python -u Downstream_main.py\
    --beta_min 0.0     --beta_max 1.0    --beta_step 0.5\
    --beta_y_min 0.0   --beta_y_max 1.0\
    --nu_min 0.0       --nu_max 1.0      --nu_step 0.5\
    --nu_y_min 0.0     --nu_y_max 1.0\
    --rho_min 0.0      --rho_max 1.0     --rho_step 0.5\
    --epsilon_min 0.0  --epsilon_max 1.0 --epsilon_step 0.5\
    --theta_min 0.0    --theta_max 1.0   --theta_step 0.5\
    --model $model --data $data --numerical 0 --extrapolation 0 --total $total\
    --N_train_shot $N_train --system "Seen coeff" --lr $lr --scheduler $scheduler\
    --nhid $nhid --nlayers $nlayers --nips $nips --nhead $nhead --fixI $fixI\
    --num_freqs $num_freqs --AGF_depth $AGF_depth --is_grid $is_grid\
    --epoch $epoch --PINN_based_prior_ratio $PINN_ratio \
    > "./logs/$model/$data/test_PINN_nh$nhid"_nl"$nlayers"_nhd"$nhead"_nf"$num_freqs"_Ad"$AGF_depth"_"$lr"_"$scheduler.log"

# Test Seen coeff extrapolation
CUDA_VISIBLE_DEVICES=$gpu python -u Downstream_main.py\
    --beta_min 0.0     --beta_max 1.0    --beta_step 0.5\
    --beta_y_min 0.0   --beta_y_max 1.0\
    --nu_min 0.0       --nu_max 1.0      --nu_step 0.5\
    --nu_y_min 0.0     --nu_y_max 1.0\
    --rho_min 0.0      --rho_max 1.0     --rho_step 0.5\
    --epsilon_min 0.0  --epsilon_max 1.0 --epsilon_step 0.5\
    --theta_min 0.0    --theta_max 1.0   --theta_step 0.5\
    --model $model --data $data --numerical 0 --extrapolation 1 --total $total\
    --N_train_shot $N_train --system "Seen coeff" --lr $lr --scheduler $scheduler\
    --nhid $nhid --nlayers $nlayers --nips $nips --nhead $nhead --fixI $fixI\
    --num_freqs $num_freqs --AGF_depth $AGF_depth --is_grid $is_grid\
    --epoch $epoch --PINN_based_prior_ratio $PINN_ratio \
    >> "./logs/$model/$data/test_PINN_nh$nhid"_nl"$nlayers"_nhd"$nhead"_nf"$num_freqs"_Ad"$AGF_depth"_"$lr"_"$scheduler.log"

# Test Inter coeff Interpolation
CUDA_VISIBLE_DEVICES=$gpu python -u Downstream_main.py\
    --beta_min 0.25     --beta_max 0.75    --beta_step 0.5\
    --beta_y_min 0.25   --beta_y_max 0.75\
    --nu_min 0.25       --nu_max 0.75      --nu_step 0.5\
    --nu_y_min 0.25     --nu_y_max 0.75\
    --rho_min 0.25      --rho_max 0.75     --rho_step 0.5\
    --epsilon_min 0.25  --epsilon_max 0.75 --epsilon_step 0.5\
    --theta_min 0.25    --theta_max 0.75   --theta_step 0.5\
    --model $model --data $data --numerical 0 --extrapolation 0 --total $total\
    --N_train_shot $N_train --system "Inter coeff" --lr $lr --scheduler $scheduler\
    --nhid $nhid --nlayers $nlayers --nips $nips --nhead $nhead --fixI $fixI\
    --num_freqs $num_freqs --AGF_depth $AGF_depth --is_grid $is_grid\
    --epoch $epoch --PINN_based_prior_ratio $PINN_ratio \
    >> "./logs/$model/$data/test_PINN_nh$nhid"_nl"$nlayers"_nhd"$nhead"_nf"$num_freqs"_Ad"$AGF_depth"_"$lr"_"$scheduler.log"

# Test Inter coeff extrapolation
CUDA_VISIBLE_DEVICES=$gpu python -u Downstream_main.py\
    --beta_min 0.25     --beta_max 0.75    --beta_step 0.5\
    --beta_y_min 0.25   --beta_y_max 0.75\
    --nu_min 0.25       --nu_max 0.75      --nu_step 0.5\
    --nu_y_min 0.25     --nu_y_max 0.75\
    --rho_min 0.25      --rho_max 0.75     --rho_step 0.5\
    --epsilon_min 0.25  --epsilon_max 0.75 --epsilon_step 0.5\
    --theta_min 0.25    --theta_max 0.75   --theta_step 0.5\
    --model $model --data $data --numerical 0 --extrapolation 1 --total $total\
    --N_train_shot $N_train --system "Inter coeff" --lr $lr --scheduler $scheduler\
    --nhid $nhid --nlayers $nlayers --nips $nips --nhead $nhead --fixI $fixI\
    --num_freqs $num_freqs --AGF_depth $AGF_depth --is_grid $is_grid\
    --epoch $epoch --PINN_based_prior_ratio $PINN_ratio \
    >> "./logs/$model/$data/test_PINN_nh$nhid"_nl"$nlayers"_nhd"$nhead"_nf"$num_freqs"_Ad"$AGF_depth"_"$lr"_"$scheduler.log"

# Test Extra coeff interpolation
CUDA_VISIBLE_DEVICES=$gpu python -u Downstream_main.py\
    --beta_min 1.25     --beta_max 1.5    --beta_step 0.25\
    --beta_y_min 1.25   --beta_y_max 1.5\
    --nu_min 1.25       --nu_max 1.5      --nu_step 0.25\
    --nu_y_min 1.25     --nu_y_max 1.5\
    --rho_min 1.25      --rho_max 1.5     --rho_step 0.25\
    --epsilon_min 1.25  --epsilon_max 1.5 --epsilon_step 0.25\
    --theta_min 1.25    --theta_max 1.5   --theta_step 0.25\
    --model $model --data $data --numerical 0 --extrapolation 0 --total $total\
    --N_train_shot $N_train --system "Extra coeff" --lr $lr --scheduler $scheduler\
    --nhid $nhid --nlayers $nlayers --nips $nips --nhead $nhead --fixI $fixI\
    --num_freqs $num_freqs --AGF_depth $AGF_depth --is_grid $is_grid\
    --epoch $epoch --PINN_based_prior_ratio $PINN_ratio \
    >> "./logs/$model/$data/test_PINN_nh$nhid"_nl"$nlayers"_nhd"$nhead"_nf"$num_freqs"_Ad"$AGF_depth"_"$lr"_"$scheduler.log"

# Test Extra coeff extrapolation
CUDA_VISIBLE_DEVICES=$gpu python -u Downstream_main.py\
    --beta_min 1.25     --beta_max 1.5    --beta_step 0.25\
    --beta_y_min 1.25   --beta_y_max 1.5\
    --nu_min 1.25       --nu_max 1.5      --nu_step 0.25\
    --nu_y_min 1.25     --nu_y_max 1.5\
    --rho_min 1.25      --rho_max 1.5     --rho_step 0.25\
    --epsilon_min 1.25  --epsilon_max 1.5 --epsilon_step 0.25\
    --theta_min 1.25    --theta_max 1.5   --theta_step 0.25\
    --model $model --data $data --numerical 0 --extrapolation 1 --total $total\
    --N_train_shot $N_train --system "Extra coeff" --lr $lr --scheduler $scheduler\
    --nhid $nhid --nlayers $nlayers --nips $nips --nhead $nhead --fixI $fixI\
    --num_freqs $num_freqs --AGF_depth $AGF_depth --is_grid $is_grid\
    --epoch $epoch --PINN_based_prior_ratio $PINN_ratio \
    >> "./logs/$model/$data/test_PINN_nh$nhid"_nl"$nlayers"_nhd"$nhead"_nf"$num_freqs"_Ad"$AGF_depth"_"$lr"_"$scheduler.log"

# Test Seen coeff interpolation given noisy
CUDA_VISIBLE_DEVICES=$gpu python -u Downstream_main.py\
    --beta_min 0.0     --beta_max 1.0    --beta_step 0.5\
    --beta_y_min 0.0   --beta_y_max 1.0\
    --nu_min 0.0       --nu_max 1.0      --nu_step 0.5\
    --nu_y_min 0.0     --nu_y_max 1.0\
    --rho_min 0.0      --rho_max 1.0     --rho_step 0.5\
    --epsilon_min 0.0  --epsilon_max 1.0 --epsilon_step 0.5\
    --theta_min 0.0    --theta_max 1.0   --theta_step 0.5\
    --model $model --data $data --numerical 0 --extrapolation 0 --total $total\
    --N_train_shot $N_train --system "Seen coeff given noisy" --lr $lr --scheduler $scheduler\
    --nhid $nhid --nlayers $nlayers --nips $nips --nhead $nhead --fixI $fixI\
    --num_freqs $num_freqs --AGF_depth $AGF_depth --is_grid $is_grid\
    --epoch $epoch --PINN_based_prior_ratio $PINN_ratio \
    > "./logs/$model/$data/test_PINN_given_noisy_nh$nhid"_nl"$nlayers"_nhd"$nhead"_nf"$num_freqs"_Ad"$AGF_depth"_"$lr"_"$scheduler.log"

# Test seen coeff extrapolation given noisy
CUDA_VISIBLE_DEVICES=$gpu python -u Downstream_main.py\
    --beta_min 0.0     --beta_max 1.0    --beta_step 0.5\
    --beta_y_min 0.0   --beta_y_max 1.0\
    --nu_min 0.0       --nu_max 1.0      --nu_step 0.5\
    --nu_y_min 0.0     --nu_y_max 1.0\
    --rho_min 0.0      --rho_max 1.0     --rho_step 0.5\
    --epsilon_min 0.0  --epsilon_max 1.0 --epsilon_step 0.5\
    --theta_min 0.0    --theta_max 1.0   --theta_step 0.5\
    --model $model --data $data --numerical 0 --extrapolation 1 --total $total\
    --N_train_shot $N_train --system "Seen coeff given noisy" --lr $lr --scheduler $scheduler\
    --nhid $nhid --nlayers $nlayers --nips $nips --nhead $nhead --fixI $fixI\
    --num_freqs $num_freqs --AGF_depth $AGF_depth --is_grid $is_grid\
    --epoch $epoch --PINN_based_prior_ratio $PINN_ratio \
    >> "./logs/$model/$data/test_PINN_given_noisy_nh$nhid"_nl"$nlayers"_nhd"$nhead"_nf"$num_freqs"_Ad"$AGF_depth"_"$lr"_"$scheduler.log"