# Fine-tuning and evaluation in CNSE dataset.

#### model hyperparameters
model="PDE_PFN"
nhid=512      # hidden dimension in en/decoder
nips=32       # 1/2 hidden dimension in transformer block
nlayers=16    # number of transformer layers
nhead=5       # number of heads in transformer layers
num_freqs=0   # number of fourier features
is_grid=0     # consider data as grid data or not
AGF_depth=15  # depth of the AGF
fixI=0        # 
dropout=0.1   # dropout rate

#### training hyperparameters
data="CNSE"             # dataset
PINN_ratio=0            # PINN ratio in pre-training model
epoch=50                # epoch
total=1                 # model type
N_train=700             # number of training sample
N_valid=100             # number of validation sample
N_test=200              # number of testing sample
batch=5                 # batch number
lr=0.0005               # learning rate
lr_decay=0.95           # learning rate decay
scheduler="OneCycleLR"  # learning rate scheduler

#### training Hardware : GPU 
gpu=4

if [[ ! -d "logs/$model/$data" ]]; then
  mkdir -p -- "logs/$model/$data"
fi

# Fine-tuning
CUDA_VISIBLE_DEVICES=$gpu python -u Train_main.py\
    --model $model --data $data --numerical 1 --extrapolation 1 --total $total\
    --N_train_shot $N_train --N_valid $N_valid --N_test $N_test\
    --lr $lr --lr_decay $lr_decay --scheduler $scheduler --dropout $dropout\
    --nhid $nhid --nlayers $nlayers --nips $nips --nhead $nhead --fixI $fixI\
    --num_freqs $num_freqs --AGF_depth $AGF_depth --batch $batch --is_grid $is_grid\
    --epoch $epoch --system "Seen dataset" --PINN_based_prior_ratio $PINN_ratio\
    > "./logs/$model/$data/train_nf$num_freqs"_"$dropout"_"$lr"_"$scheduler.log"

# Test Unseen dataset operator learning problem
CUDA_VISIBLE_DEVICES=$gpu python -u Downstream_main.py\
    --model $model --data $data --numerical 1 --extrapolation 1 --total $total\
    --N_train_shot $N_train --N_valid $N_valid --N_test $N_test\
    --lr $lr --lr_decay $lr_decay --scheduler $scheduler --dropout $dropout\
    --nhid $nhid --nlayers $nlayers --nips $nips --nhead $nhead --fixI $fixI\
    --num_freqs $num_freqs --AGF_depth $AGF_depth --is_grid $is_grid\
    --epoch $epoch --system "Unseen dataset" --PINN_based_prior_ratio $PINN_ratio \
    > "./logs/$model/$data/test_nf$num_freqs"_"$dropout"_"$lr"_"$scheduler.log"