# Fine-tuning and evaluation in SWE dataset.

#### model hyperparameters
model="PDE_PFN"
nhid=512      # hidden dimension in en/decoder
nips=32       # 1/2 hidden dimension in transformer block
nlayers=16    # number of transformer layers
nhead=5       # number of heads in transformer layers
num_freqs=0   # number of fourier features
is_grid=0     # consider data as grid data or not
AGF_depth=15  # depth of the AGF
fixI=0        # 
dropout=0.2   # dropout rate

#### training hyperparameters
data="SWE"                  # dataset
PINN_ratio=0                # PINN ratio in pre-training model
epoch=50                    # epoch
total=1                     # model type
N_train=700                 # number of training sample
batch=2                     # batch number
lr=0.0005                   # learning rate
lr_decay=0.95               # learning rate decay
scheduler="warmup_linear"   # learning rate scheduler

#### training Hardware : GPU 
gpu=0

if [[ ! -d "logs/$model/$data" ]]; then
  mkdir -p -- "logs/$model/$data"
fi

# Fine-tuning
CUDA_VISIBLE_DEVICES=$gpu python -u Train_main.py\
    --model $model --data $data --numerical 1 --extrapolation 1 --total $total\
    --N_train_shot $N_train --lr $lr --lr_decay $lr_decay --scheduler $scheduler --dropout $dropout\
    --nhid $nhid --nlayers $nlayers --nips $nips --nhead $nhead --fixI $fixI\
    --num_freqs $num_freqs --AGF_depth $AGF_depth --batch $batch\
    --epoch $epoch --system "Seen dataset" --PINN_based_prior_ratio $PINN_ratio\
    > "./logs/$model/$data/train_nf$num_freqs"_"$dropout"_"$lr"_"$scheduler.log"

# Test seen dataset interpolation problem
CUDA_VISIBLE_DEVICES=$gpu python -u Downstream_main.py\
    --model $model --data $data --numerical 1 --extrapolation 0 --total $total\
    --N_train_shot $N_train --lr $lr --lr_decay $lr_decay --scheduler $scheduler --dropout $dropout\
    --nhid $nhid --nlayers $nlayers --nips $nips --nhead $nhead --fixI $fixI\
    --num_freqs $num_freqs --AGF_depth $AGF_depth\
    --epoch $epoch --system "Seen dataset" --PINN_based_prior_ratio $PINN_ratio \
    > "./logs/$model/$data/test_nf$num_freqs"_"$dropout"_"$lr"_"$scheduler.log"

# Test seen dataset extrapolation problem
CUDA_VISIBLE_DEVICES=$gpu python -u Downstream_main.py\
    --model $model --data $data --numerical 1 --extrapolation 1 --total $total\
    --N_train_shot $N_train --lr $lr --lr_decay $lr_decay --scheduler $scheduler --dropout $dropout\
    --nhid $nhid --nlayers $nlayers --nips $nips --nhead $nhead --fixI $fixI\
    --num_freqs $num_freqs --AGF_depth $AGF_depth\
    --epoch $epoch --system "Seen dataset" --PINN_based_prior_ratio $PINN_ratio \
    >> "./logs/$model/$data/test_nf$num_freqs"_"$dropout"_"$lr"_"$scheduler.log"

# Test unseen dataset interpolation problem
CUDA_VISIBLE_DEVICES=$gpu python -u Downstream_main.py\
    --model $model --data $data --numerical 1 --extrapolation 0 --total $total\
    --N_train_shot $N_train --lr $lr --lr_decay $lr_decay --scheduler $scheduler --dropout $dropout\
    --nhid $nhid --nlayers $nlayers --nips $nips --nhead $nhead --fixI $fixI\
    --num_freqs $num_freqs --AGF_depth $AGF_depth\
    --epoch $epoch --system "Unseen dataset" --PINN_based_prior_ratio $PINN_ratio \
    >> "./logs/$model/$data/test_nf$num_freqs"_"$dropout"_"$lr"_"$scheduler.log"

# Test unseen dataset extrapolation problem
CUDA_VISIBLE_DEVICES=$gpu python -u Downstream_main.py\
    --model $model --data $data --numerical 1 --extrapolation 1 --total $total\
    --N_train_shot $N_train --lr $lr --lr_decay $lr_decay --scheduler $scheduler --dropout $dropout\
    --nhid $nhid --nlayers $nlayers --nips $nips --nhead $nhead --fixI $fixI\
    --num_freqs $num_freqs --AGF_depth $AGF_depth\
    --epoch $epoch --system "Unseen dataset" --PINN_based_prior_ratio $PINN_ratio \
    >> "./logs/$model/$data/test_nf$num_freqs"_"$dropout"_"$lr"_"$scheduler.log"

