from setuptools import setup, Extension
from torch.utils.cpp_extension import BuildExtension, CUDAExtension


setup(
    name='sgemm_cuda',
    ext_modules=[
            CUDAExtension(
                name='sgemm_cuda',
                sources=['sgemm_cuda.cpp','sgemm_cuda_kernel.cu'],
                # Command parameters for compiling extension package(Extra compilation coptions)
                extra_compile_args={
                    'cxx': [],
                    'nvcc': [
                        '-gencode=arch=compute_37,code=sm_37',
                        '-gencode=arch=compute_50,code=sm_50',
                        '-gencode=arch=compute_60,code=sm_60',
                        '-gencode=arch=compute_61,code=sm_61',
                        '-gencode=arch=compute_70,code=sm_70',
                        '-gencode=arch=compute_75,code=sm_75',
                        #'-gencode=arch=compute_80,code=sm_80',
                        #'-gencode=arch=compute_86,code=sm_86',
                        '-gencode=arch=compute_37,code=compute_37'
                    ]
                }
            )
        ],
    cmdclass={
        'build_ext': BuildExtension
    }
)

