import json
from os import listdir
from os.path import isfile, join

path = '/home/joel_jang/dongkeun/L2U/configs/examples'
onlyfiles = [f for f in listdir(path) if isfile(join(path, f))]

for file in onlyfiles:
    f = open(join(path, file))
    data = json.load(f)
    data['mode'] = 'general_lm_eval'
    data['valid_sets'] = [
        "ai2_arc",
        "ai2_arc",
        "super_glue",
        "winogrande",
        "math_qa",
        "data_sample/pubmed_qa.csv",
        "data_sample/wikitext.csv"
    ]
    data['subset_path'] = [
        "ARC-Easy",
        "ARC-Challenge",
        "copa",
        "winogrande_s",
        "",
        "",
        ""
    ]
    data['valid_type_path'] = [
        "validation",
        "validation",
        "validation",
        "validation",
        "validation",
        "",
        ""
    ]

    with open(f'/home/joel_jang/dongkeun/L2U/configs/examples/{file}', 'w') as fp:
        json.dump(data, fp, indent=4)