from os import listdir
from os.path import isfile, join
import pandas as pd
import re


def split_in_half(x):
    x = x.split(' ')
    length = len(x) // 2
    return [' '.join(x[:length]), ' '.join(x[length:])]


path = 'data/'
onlyfiles = [f for f in listdir(path) if isfile(join(path, f))]

print(onlyfiles)

for file in onlyfiles:
    df = pd.read_csv(join(path, file))
    shorter = df['text'].apply(split_in_half)
    shorter = shorter.explode('text')
    prefix = file.replace('.csv', '')
    shorter.to_csv(join(path, f'{prefix}_512.csv'), index=False)
