import os
os.environ['CUDA_VISIBLE_DEVICES'] = ''

from pbr import PBR
from dkwt import DKWT
import numpy as np
import pandas as pd
import gc

folder = "/root/main/ranking/sim/separated_32_100"
mode = 'pbr'
#mode = 'noinf'

vecs = np.loadtxt(os.path.join(folder, 'vecs.txt'))
q = np.loadtxt(os.path.join(folder, 'q.txt'))

def append_to_df(df, df_in):
    # Convert the dict to DataFrame
    # Append the dict DataFrame to the original DataFrame
    df = pd.concat([df, df_in], ignore_index=True)
    return df

var_tup = ('eps', [0.1])

log_df = pd.DataFrame()

for i in range(q.shape[0]):
    print(f'\n\n\n -------ITERATION {i}----------------------- \n\n\n')
    if os.path.exists(os.path.join(folder, f'log_{mode}.csv')):
        results = pd.read_csv(os.path.join(folder, f'log_{mode}.csv')).sort_values(['q_idx'], inplace=False)
        if len(results.loc[(results['q_idx']==i)])!=0:
            print('Entry already exists, skipping ...')
            continue
    else:
        results = pd.DataFrame()
    try:
        if mode == 'noinf':
            print('Running noinf')
            pbr = PBR(vecs, update_inf=False, random_build=True)
        else:
            pbr = PBR(vecs, update_inf=True)
        tmp = pbr.run_sim(q[i,:], log_freq=500)
        tmp['q_idx'] = i
        results = append_to_df(results, tmp).to_csv(os.path.join(folder, f'log_{mode}.csv'), index=False)
        del results
        del pbr
        del tmp
        gc.collect()
    except Exception as e:
        print(f'{e}: continuing to next iteration')
