import os
os.environ['CUDA_VISIBLE_DEVICES'] = ''

from pbr import PBR
from dkwt import DKWT
import numpy as np
from cProfile import Profile
from pstats import SortKey, Stats

def preproc(vecs:np.array, noise=True):
    vecs = vecs - vecs.mean(0,keepdims=True)
    vecs = vecs/np.linalg.norm(vecs, axis=-1, keepdims=True)
    noise_term = np.random.randn(*vecs.shape)
    noise_term = noise_term/np.linalg.norm(noise_term, axis=-1, keepdims=True)
    vecs = vecs + 0.2*noise_term
    vecs = vecs/np.linalg.norm(vecs, axis=-1, keepdims=True)
    return vecs

file = "/main/ranking/data/separated/dim32.txt"
vecs = np.loadtxt(file)
vecs = preproc(vecs)
print(f"data dimension: {vecs.shape}")

pbr = PBR(vecs, update_inf=True, eps=0.1)
if False:
    if vecs.min()>0:
        pbr.run_sim(np.random.rand(vecs.shape[1]))
    else:
        pbr.run_sim(np.random.randn(vecs.shape[1]))
else:
    noise_term = np.random.randn(vecs.shape[1])
    noise_term = noise_term/np.linalg.norm(noise_term, keepdims=True)
    if False:
        with Profile() as profile:
            print(f"{pbr.run_sim(vecs[5,:] + 0.4 * noise_term) = }")
            (
            Stats(profile)
                .strip_dirs()
                .sort_stats(SortKey.CALLS)
                .print_stats()
            )
    else:
        pbr.run_sim(vecs[5,:] + 0.4 * noise_term)