##### CSV Output #####
Note that training progress is conveyed through console outputs, where per-epoch statements are outputed to indicate epoch time and train/test loss/accuracy.

Note also that a per-epoch `.csv` file is created for every training session. This file reports performance metrics of the CNN during training.

Table 2: Performance metrics of ResNet18 trained on CIFAR10 using AdaM - 1 Epoch
|layer|train_acc1_epoch_0 |train_acc5_epoch_0|train_loss_epoch_0|in_S_epoch_0        |out_S_epoch_0       |fc_S_epoch_0        |in_rank_epoch_0   |out_rank_epoch_0|fc_rank_epoch_0|in_condition_epoch_0|out_condition_epoch_0|learning_rate_epoch_0|test_acc1_epoch_0 |test_acc5_epoch_0 |test_loss_epoch_0 |
|-----|-------------------|------------------|------------------|--------------------|--------------------|--------------------|------------------|----------------|---------------|--------------------|---------------------|---------------------|------------------|------------------|------------------|
|0    |0.33135997772216796|0.8405799865722656|1.8414185470937159|0.4515664180119832  |0.06103520467877388 |0.025225311517715454|0.6666666666666666|0.078125        |0.1484375      |2.8192899227142334  |1.950277328491211    |0.01                 |0.4430999755859375|0.9270999908447266|1.5043494595757014|
|1    |0.33135997772216796|0.8405799865722656|1.8414185470937159|0.11064449697732925 |0.10748620331287384 |0.025225311517715454|0.296875          |0.296875        |0.1484375      |9.55576229095459    |9.827608108520508    |0.01                 |0.4430999755859375|0.9270999908447266|1.5043494595757014|
|2    |0.33135997772216796|0.8405799865722656|1.8414185470937159|0.11085689067840576 |0.11386629939079285 |0.025225311517715454|0.28125           |0.296875        |0.1484375      |8.507970809936523   |8.191402435302734    |0.01                 |0.4430999755859375|0.9270999908447266|1.5043494595757014|
|3    |0.33135997772216796|0.8405799865722656|1.8414185470937159|0.09835807979106903 |0.09796248376369476 |0.025225311517715454|0.234375          |0.234375        |0.1484375      |7.111611366271973   |7.215683937072754    |0.01                 |0.4430999755859375|0.9270999908447266|1.5043494595757014|
|4    |0.33135997772216796|0.8405799865722656|1.8414185470937159|0.09535550326108932 |0.10251367092132568 |0.025225311517715454|0.21875           |0.234375        |0.1484375      |7.412333965301514   |6.6475114822387695   |0.01                 |0.4430999755859375|0.9270999908447266|1.5043494595757014|
|5    |0.33135997772216796|0.8405799865722656|1.8414185470937159|0.1090967208147049  |0.05894416943192482 |0.025225311517715454|0.296875          |0.1640625       |0.1484375      |8.24145793914795    |8.45368766784668     |0.01                 |0.4430999755859375|0.9270999908447266|1.5043494595757014|
|6    |0.33135997772216796|0.8405799865722656|1.8414185470937159|0.05974968522787094 |0.06477361917495728 |0.025225311517715454|0.1953125         |0.203125        |0.1484375      |10.138392448425293  |9.214241027832031    |0.01                 |0.4430999755859375|0.9270999908447266|1.5043494595757014|
|7    |0.33135997772216796|0.8405799865722656|1.8414185470937159|0.07129481434822083 |0.03564448654651642 |0.025225311517715454|0.125             |0.0625          |0.1484375      |3.8008110523223877  |3.802281618118286    |0.01                 |0.4430999755859375|0.9270999908447266|1.5043494595757014|
|8    |0.33135997772216796|0.8405799865722656|1.8414185470937159|0.05065574869513512 |0.04986543208360672 |0.025225311517715454|0.1875            |0.1875          |0.1484375      |11.022015571594238  |10.463407516479492   |0.01                 |0.4430999755859375|0.9270999908447266|1.5043494595757014|
|9    |0.33135997772216796|0.8405799865722656|1.8414185470937159|0.041666824370622635|0.04442698135972023 |0.025225311517715454|0.15625           |0.1640625       |0.1484375      |10.325142860412598  |10.461980819702148   |0.01                 |0.4430999755859375|0.9270999908447266|1.5043494595757014|
|10   |0.33135997772216796|0.8405799865722656|1.8414185470937159|0.06222112104296684 |0.03330986201763153 |0.025225311517715454|0.21875           |0.1171875       |0.1484375      |11.795066833496094  |10.482759475708008   |0.01                 |0.4430999755859375|0.9270999908447266|1.5043494595757014|
|11   |0.33135997772216796|0.8405799865722656|1.8414185470937159|0.03678721562027931 |0.044352397322654724|0.025225311517715454|0.140625          |0.15234375      |0.1484375      |12.017600059509277  |10.298474311828613   |0.01                 |0.4430999755859375|0.9270999908447266|1.5043494595757014|
|12   |0.33135997772216796|0.8405799865722656|1.8414185470937159|0.04655494540929794 |0.0232760701328516  |0.025225311517715454|0.09375           |0.046875        |0.1484375      |5.38632345199585    |5.388286113739014    |0.01                 |0.4430999755859375|0.9270999908447266|1.5043494595757014|
|13   |0.33135997772216796|0.8405799865722656|1.8414185470937159|0.030910596251487732|0.02923048473894596 |0.025225311517715454|0.140625          |0.125           |0.1484375      |12.300890922546387  |11.473641395568848   |0.01                 |0.4430999755859375|0.9270999908447266|1.5043494595757014|
|14   |0.33135997772216796|0.8405799865722656|1.8414185470937159|0.025456098839640617|0.03196844086050987 |0.025225311517715454|0.125             |0.13671875      |0.1484375      |13.681483268737793  |12.069375038146973   |0.01                 |0.4430999755859375|0.9270999908447266|1.5043494595757014|
|15   |0.33135997772216796|0.8405799865722656|1.8414185470937159|0.0342952199280262  |0.021910717710852623|0.025225311517715454|0.18359375        |0.103515625     |0.1484375      |16.415645599365234  |13.604710578918457   |0.01                 |0.4430999755859375|0.9270999908447266|1.5043494595757014|
|16   |0.33135997772216796|0.8405799865722656|1.8414185470937159|0.020953113213181496|0.02875955030322075 |0.025225311517715454|0.158203125       |0.169921875     |0.1484375      |23.98558807373047   |19.041444778442383   |0.01                 |0.4430999755859375|0.9270999908447266|1.5043494595757014|
|17   |0.33135997772216796|0.8405799865722656|1.8414185470937159|0.030703796073794365|0.015351674519479275|0.025225311517715454|0.10546875        |0.052734375     |0.1484375      |13.296284675598145  |13.29802417755127    |0.01                 |0.4430999755859375|0.9270999908447266|1.5043494595757014|
|18   |0.33135997772216796|0.8405799865722656|1.8414185470937159|0.03207405284047127 |0.03128455579280853 |0.025225311517715454|0.173828125       |0.150390625     |0.1484375      |17.165842056274414  |15.62701416015625    |0.01                 |0.4430999755859375|0.9270999908447266|1.5043494595757014|
|19   |0.33135997772216796|0.8405799865722656|1.8414185470937159|0.020864782854914665|0.025225311517715454|0.025225311517715454|0.16015625        |0.1484375       |0.1484375      |28.61431884765625   |23.50200843811035    |0.01                 |0.4430999755859375|0.9270999908447266|1.5043494595757014|

Where each row represents a single convolutional block and:
- **train_acc1_epoch_0** is the top-1 training accuracy
- **train_acc5_epoch_0** is the top-5 training accuracy
- **train_loss_epoch_0** is the training loss
- **in_S_epoch_0** is the input knowledge gain
- **out_S_epoch_0** is the output knowledge gain
- **fc_S_epoch_0** is the knolwedge gain of the layer's fc-layer
- **in_rank_epoch_0** is the input rank
- **out_rank_epoch_0** is the output rank
- **fc_rank_epoch_0** is the rank of the layer's fc-layer
- **in_condition_epoch_0** is the input mapping condition
- **out_condition_epoch_0** is the output mapping condition
- **learning_rate_epoch_0** is the learning rate
- **test_acc1_epoch_0** is the top-1 test accuracy
- **test_acc5_epoch_0** is the top-5 test accuracy
- **test_loss_epoch_0** is the testing loss

**Note** that there is also potentially an additional column when training using [AdaS](https://github.com/mahdihosseini/AdaS)
- **rank_velocity_epoch_0**

The columns will continue to grow during training, appending each epoch's metrics each time.

The location of the output `.csv` file depends on the `--root` and `--output` option during training, and naming of the file is determined by the `config.yaml` file's contents.

##### Checkpoints #####
Checkpoints are saved to the path specified by the `-root` and `--checkpoint` option. A file or directory may be passed. If a directory path is specified, the filename for the checkpoint defaults to `ckpt.pth`.
