# Linear Tiling Activation (LTA)

This repository contains:
- A PyTorch implementation of LTA.  See `networks.py`
- The code which executes, records, and plots all results on the Piecewise Random Walk Problem.

## Replicating Figure 3, 16, 17, 18

Perform the following steps:

- Adjust `main_2_layer.py` to the desired number of runs.

   (Paper uses 30.)

- Run `main_2_layer.py` until all runs complete.

   Individual run notebooks, results, single run plots are saved to the `results/` directory.

- Adjust `plot_2_layer_results.ipynb`.

   Ensure `basename = '2_layer'`, and that `num_runs` matches your number of runs.  (Adjust `shading_p_value` to be sensible w.r.t. your chosen number of runs.)

- Run `plot_2_layer_results.ipynb`.

   Sensitivity curves, sampling trajectories, learning curves, and the main difficulty sweep summary plot are saved to `plots/` directory.


## Replicating Figure 19

Repeat the above process, replacing:

- `main_2_layer.py` with `main_2_layer_large_relu.py`
- `basename = '2_layer'` with `basename = '2_layer_large_relu'`

## Replicating Figure 20

Repeat the above process, replacing:

- `main_2_layer.py` with `main_2_layer_batching_50.py`
- `basename = '2_layer'` with `basename = '2_layer_batching_50'`

# Replicating network width search from Section A.7.2

- Run `width_search_two_layer_lta.ipynb`, manually choose width `k` which optimizes performance (i.e. at the minimum of the classical bias-variance tradeoff.)
- Run `width_search_two_layer_relu.ipynb`, manually choose width `k` similarly.
