import os
import json
import torch

from pathlib import Path


def save_results(results, filename):
    with open(filename, 'wb') as f:
        torch.save(results, f)


def load_results(filename):
    with open(filename, 'rb') as f:
        results = torch.load(f)
    return results


def dir_name(base_name):
    return os.path.join('results', base_name)


def full_path(base_name, file_name):
    return os.path.join(dir_name(base_name), file_name)


def args_filename(base_name):
    return full_path(base_name, 'args.json')


def ensure_results_dir(base_name, **kwargs):
    directory = dir_name(base_name)
    Path(directory).mkdir(parents=True, exist_ok=True)
    with open(args_filename(base_name), 'w') as f:
        json.dump(kwargs, f)


def load_experiment_params(base_name):
    with open(args_filename(base_name), 'r') as f:
        args = json.load(f)

    return args
