import matplotlib.pyplot as plt
import numpy as np

# Define the dataset names and model types
datasets = ['PTE', 'OASIS-3', 'TaoWu', 'Neurocon']
models = ['SVM', 'RF', 'LR']

# Performance metrics and standard deviations for each dataset and model configuration
performance_data = {
    'PTE': {
        'SVM': {'means': [0.6415, 0.6167, 0.5697], 'stds': [0.0312, 0.0413, 0.0477]},
        'RF': {'means': [0.5392, 0.5257, 0.5081], 'stds': [0.0553, 0.0504, 0.0612]},
        'LR': {'means': [0.5770, 0.5811, 0.5190], 'stds': [0.0625, 0.0497, 0.0566]}
    },
    'OASIS-3': {
        'SVM': {'means': [0.6407, 0.6774, 0.5541], 'stds': [0.0741, 0.0722, 0.0677]},
        'RF': {'means': [0.6750, 0.6843, 0.5329], 'stds': [0.0753, 0.0773, 0.0721]},
        'LR': {'means': [0.5894, 0.5911, 0.5482], 'stds': [0.0544, 0.0581, 0.0520]}
    },
    'TaoWu': {
        'SVM': {'means': [0.6831, 0.6725, 0.5725], 'stds': [0.1431, 0.1698, 0.1502]},
        'RF': {'means': [0.6553, 0.6578, 0.6031], 'stds': [0.1701, 0.1802, 0.1631]},
        'LR': {'means': [0.5725, 0.5634, 0.5275], 'stds': [0.1696, 0.1674, 0.2057]}
    },
    'Neurocon': {
        'SVM': {'means': [0.7529, 0.7583, 0.6599], 'stds': [0.1579, 0.1424, 0.1807]},
        'RF': {'means': [0.6230, 0.6766, 0.5427], 'stds': [0.1658, 0.1618, 0.1715]},
        'LR': {'means': [0.5885, 0.5798, 0.5163], 'stds': [0.1815, 0.1911, 0.2167]}
    }
}

fig, axes = plt.subplots(nrows=1, ncols=4, figsize=(20, 5), sharey=True)

colors = [['#C7E9C0', '#C7E9C0','#C7E9C0'], ['#87CEFA', '#87CEFA', '#87CEFA'], ['#FFFDD0', '#FFFDD0', '#FFFDD0']]
bar_width = 0.25

# Loop through each dataset and create a subplot for each
for i, dataset in enumerate(datasets):
    ax = axes[i]
    index = np.arange(len(models))

    # Plot each model's performance as a group of bars in the subplot
    for j, model in enumerate(models):
        means = []
        stds = []
        for model in models:
            means.append( performance_data[dataset][model]['means'][j])
        # print(means)
            stds.append(performance_data[dataset][model]['stds'][j])

        ax.bar(index + bar_width*j, means, bar_width, yerr=stds, capsize=3,
               label=f'{["MeTSK-ADHD-Peking", "MeTSK-ADHD-All", "Connectivity Features"][j]}', color=colors[j],error_kw={'elinewidth': 1})

    # Add text for labels and title
    ax.set_title(f'{dataset}')
    ax.set_xticks(index + bar_width, labels=models)
    # ax.set_xlabel('Classifier')
    current_ticks = list(ax.get_yticks())
    custom_ticks = [0.5, 0.55, 0.65, 0.75]
    all_ticks = np.unique(np.concatenate([ax.get_yticks(), custom_ticks]))
    ax.set_yticks(all_ticks)

    # Customize specific tick labels to normal weight
    for label in ax.get_yticklabels():
        if label.get_text() in map(str, custom_ticks):  # Convert to string for comparison
            label.set_fontweight('normal')
    if i == 0:
        ax.set_ylabel('AUC')
        

# Place the legend in the upper left of the first subplot
axes[0].legend(loc='upper left')

# plt.suptitle('A comparison between the foundation model pre-trained with ')
# plt.tight_layout()
plt.tight_layout(pad=1, h_pad=None, w_pad=None, rect=[0.01, 0, 1, 1])
plt.show()
