import argparse
from tqdm import tqdm

def get_params():
    parser = argparse.ArgumentParser(description='tomita_lstm')
    parser.add_argument('--f1', required=True)
    parser.add_argument('--f2', required=True)
    args = parser.parse_args()
    return args

if __name__ == "__main__":
    args = get_params()
    with open(args.f1, "r+") as ff:
        strings_1 = ff.readlines()

    with open(args.f2, "r+") as ff:
        strings_2 = ff.readlines()

    overlap = 0
    for ss in tqdm(strings_1):
        if ss in strings_2:
            overlap += 1

    print("strings1 : {} strings2 : {} overlap : {}".format(len(strings_1), len(strings_2), overlap))

