import argparse
import json
import random

# python dyck_depth.py --data_file "../data/dyck/dyck_2_50_pos_train.json" --n_pairs 2

def get_params():
    parser = argparse.ArgumentParser(description='dyck_generator')
    parser.add_argument('--data_file', type=st
    parser.add_argument('--n_pairs', type=int)
    args = parser.parse_args()
    return args


all_pairs = ['()', '[]', '{}', '<>', '+-', 'ab', 'xo']

if __name__ == "__main__":
    args = get_params()
    with open(args.data_file, "r+") as ff:
        data = json.load(ff)

    pairs = all_pairs[:args.n_pairs]
    open_par = [p[0] for p in pairs]
    close_par = [p[1] for p in pairs]
    max_depth = 0
    for d in data:
        ss = d["inp"]
        depth = 0
        for ch in ss:
            if  ch in open_par:
                depth += 1
                max_depth = max(depth, max_depth)
            elif ch in close_par:
                depth -= 1

    print("Max depth : ", max_depth)


