#!/usr/bin/env bash

# ### Dyck -2 
# python dyck_preprocess_data.py \
#     --max_len 52 \
#     --inp_fpath "../data/dyck/dyck_2_50_pos_train.json" \
#     --out_fpath "../data/dyck/dyck_2_50_pos_train.npz" \
#     --vocab_fpath "../data/dyck/dyck_2_vocab.json"

# python dyck_preprocess_data.py \
#     --max_len 52 \
#     --inp_fpath "../data/dyck/dyck_2_50_neg_train.json" \
#     --out_fpath "../data/dyck/dyck_2_50_neg_train.npz" \
#     --vocab_fpath "../data/dyck/dyck_2_vocab.json"

# python dyck_preprocess_data.py \
#     --max_len 52 \
#     --inp_fpath "../data/dyck/dyck_2_50_pos_val.json" \
#     --out_fpath "../data/dyck/dyck_2_50_pos_val.npz" \
#     --vocab_fpath "../data/dyck/dyck_2_vocab.json"

# python dyck_preprocess_data.py \
#     --max_len 52 \
#     --inp_fpath "../data/dyck/dyck_2_50_neg_val.json" \
#     --out_fpath "../data/dyck/dyck_2_50_neg_val.npz" \
#     --vocab_fpath "../data/dyck/dyck_2_vocab.json"

# python dyck_preprocess_data.py \
#     --max_len 52 \
#     --inp_fpath "../data/dyck/dyck_2_50_pos_test.json" \
#     --out_fpath "../data/dyck/dyck_2_50_pos_test.npz" \
#     --vocab_fpath "../data/dyck/dyck_2_vocab.json"

# python dyck_preprocess_data.py \
#     --max_len 52 \
#     --inp_fpath "../data/dyck/dyck_2_50_neg_test.json" \
#     --out_fpath "../data/dyck/dyck_2_50_neg_test.npz" \
#     --vocab_fpath "../data/dyck/dyck_2_vocab.json"

# python dyck_preprocess_data.py \
#     --max_len 102 \
#     --inp_fpath "../data/dyck/dyck_2_100_pos_test.json" \
#     --out_fpath "../data/dyck/dyck_2_100_pos_test.npz" \
#     --vocab_fpath "../data/dyck/dyck_2_vocab.json"

# python dyck_preprocess_data.py \
#     --max_len 102 \
#     --inp_fpath "../data/dyck/dyck_2_100_neg_test.json" \
#     --out_fpath "../data/dyck/dyck_2_100_neg_test.npz" \
#     --vocab_fpath "../data/dyck/dyck_2_vocab.json"


# ### Dyck 3

# python dyck_preprocess_data.py \
#     --max_len 52 \
#     --inp_fpath "../data/dyck/dyck_3_50_pos_train.json" \
#     --out_fpath "../data/dyck/dyck_3_50_pos_train.npz" \
#     --vocab_fpath "../data/dyck/dyck_3_vocab.json"

# python dyck_preprocess_data.py \
#     --max_len 52 \
#     --inp_fpath "../data/dyck/dyck_3_50_neg_train.json" \
#     --out_fpath "../data/dyck/dyck_3_50_neg_train.npz" \
#     --vocab_fpath "../data/dyck/dyck_3_vocab.json"

# python dyck_preprocess_data.py \
#     --max_len 52 \
#     --inp_fpath "../data/dyck/dyck_3_50_pos_val.json" \
#     --out_fpath "../data/dyck/dyck_3_50_pos_val.npz" \
#     --vocab_fpath "../data/dyck/dyck_3_vocab.json"

# python dyck_preprocess_data.py \
#     --max_len 52 \
#     --inp_fpath "../data/dyck/dyck_3_50_neg_val.json" \
#     --out_fpath "../data/dyck/dyck_3_50_neg_val.npz" \
#     --vocab_fpath "../data/dyck/dyck_3_vocab.json"

# python dyck_preprocess_data.py \
#     --max_len 52 \
#     --inp_fpath "../data/dyck/dyck_3_50_pos_test.json" \
#     --out_fpath "../data/dyck/dyck_3_50_pos_test.npz" \
#     --vocab_fpath "../data/dyck/dyck_3_vocab.json"

# python dyck_preprocess_data.py \
#     --max_len 52 \
#     --inp_fpath "../data/dyck/dyck_3_50_neg_test.json" \
#     --out_fpath "../data/dyck/dyck_3_50_neg_test.npz" \
#     --vocab_fpath "../data/dyck/dyck_3_vocab.json"

# python dyck_preprocess_data.py \
#     --max_len 102 \
#     --inp_fpath "../data/dyck/dyck_3_100_pos_test.json" \
#     --out_fpath "../data/dyck/dyck_3_100_pos_test.npz" \
#     --vocab_fpath "../data/dyck/dyck_3_vocab.json"

# python dyck_preprocess_data.py \
#     --max_len 102 \
#     --inp_fpath "../data/dyck/dyck_3_100_neg_test.json" \
#     --out_fpath "../data/dyck/dyck_3_100_neg_test.npz" \
#     --vocab_fpath "../data/dyck/dyck_3_vocab.json"

for g in 6 8
do
    for ttype in train test val
    do
        for pn in pos neg
        do
            python dyck_preprocess_data.py \
                --max_len 52 \
                --inp_fpath "../data/dyck/dyck_${g}_50_${pn}_${ttype}.json" \
                --out_fpath "../data/dyck/dyck_${g}_50_${pn}_${ttype}.npz" \
                --vocab_fpath "../data/dyck/dyck_${g}_vocab.json"
        done
    done

    for pn in pos neg
    do
        python dyck_preprocess_data.py \
            --max_len 102 \
            --inp_fpath "../data/dyck/dyck_${g}_100_${pn}_test.json" \
            --out_fpath "../data/dyck/dyck_${g}_100_${pn}_test.npz" \
            --vocab_fpath "../data/dyck/dyck_${g}_vocab.json"
    done

done