#!/usr/bin/env bash
g=2
bdim=2
for model in lstm gru o2rnn mirnn
do
    for seed in 4240 1136 8204 6264 8634 1646 3199 6735 3933 1470
    do
        for nbin in 0 1
        do
            if [[ $nbin == 0 ]]
            then
                dsize=50
            else
                dsize=100
            fi
            
            for mdim in 1 2 3 4 5
            do
                sdim=$((bdim*mdim))
                echo "======================================================================="
                echo "model : ${model} seed : ${seed} state_dim : ${sdim} test bin : ${nbin}"
                echo "======================================================================="

                python test_lstar_dfa.py \
                    --suffix "dyck_g${g}_sdim_${sdim}_es_${es}_bce" \
                    --dfa_path "../lstar_dfa/dfa_lstar_rnn_dyck_${model}_g${g}_sdim_${sdim}_seed_${seed}.dfa" \
                    --seed $seed \
                    --state_dim $sdim\
                    --model "rnn" \
                    --rnn_cell $model \
                    --mtype "classification" \
                    --grammar "dyck-${g}"\
                    --dtype "test" \
                    --nbin $nbin \
                    --dataset "dyck_${g}_${dsize}" \
                    --result_file "../results/dyck_lstar_dfa/g${g}_${model}_sdim_${sdim}_nbin_${nbin}.json" \
                    --remove_start \
                    --remove_end
            done
        done 
    done
done
