#!/usr/bin/env bash
for g in 1 2 3 4 5 6 7
do
	echo "================================="
	echo "grammar "$g
	echo "================================="
	src="../data/MSI/Tomita-${g}"
	tgt="../data/MSI_processed/Tomita-${g}"
	mkdir -p $tgt
	for ttype in partial_target
	do
		for tv in train val
		do
			python preprocess.py --infile "${src}/${tv}_neg_${ttype}.txt" --outfile "${tgt}/${tv}_neg_${ttype}.pt" --max_len 52 --partial_target
			echo "created ${tgt}/${tv}_neg_${ttype}.pt"
			python preprocess.py --infile "${src}/${tv}_${ttype}.txt" --outfile "${tgt}/${tv}_${ttype}.pt" --max_len 52 --partial_target
			echo "created ${tgt}/${tv}_${ttype}.pt"
		done
	done
done
