#!/usr/bin/env bash
for g in 1 2 3 4 5 6 7
do
	echo "================================="
	echo "grammar "$g
	echo "================================="
	src="../data/MSI/Tomita-${g}"
	tgt="../data/MSI_processed/Tomita-${g}"
	mkdir -p $tgt

	b=0
	mlen=52
	ttype="src"
	python preprocess.py --infile "${src}/test_neg_${ttype}_bin${b}.txt" --outfile "${tgt}/test_neg_${ttype}_bin${b}.pt" --max_len $mlen 
	echo "created ${tgt}/test_neg_${ttype}_bin${b}.pt"
	python preprocess.py --infile "${src}/test_${ttype}_bin${b}.txt" --outfile "${tgt}/test_${ttype}_bin${b}.pt" --max_len $mlen 
	echo "created ${tgt}/test_${ttype}_bin${b}.pt"

	ttype="partial_target"
	python preprocess.py --infile "${src}/test_neg_${ttype}_bin${b}.txt" --outfile "${tgt}/test_neg_${ttype}_bin${b}.pt" --max_len $mlen --partial_target
	echo "created ${tgt}/test_neg_${ttype}_bin${b}.pt"
	python preprocess.py --infile "${src}/test_${ttype}_bin${b}.txt" --outfile "${tgt}/test_${ttype}_bin${b}.pt" --max_len $mlen --partial_target
	echo "created ${tgt}/test_${ttype}_bin${b}.pt"

	b=1
	mlen=102
	ttype="src"
	python preprocess.py --infile "${src}/test_neg_${ttype}_bin${b}.txt" --outfile "${tgt}/test_neg_${ttype}_bin${b}.pt" --max_len $mlen
	echo "created ${tgt}/test_neg_${ttype}_bin${b}.pt"
	python preprocess.py --infile "${src}/test_${ttype}_bin${b}.txt" --outfile "${tgt}/test_${ttype}_bin${b}.pt" --max_len $mlen
	echo "created ${tgt}/test_${ttype}_bin${b}.pt"

	ttype="partial_target"
	python preprocess.py --infile "${src}/test_neg_${ttype}_bin${b}.txt" --outfile "${tgt}/test_neg_${ttype}_bin${b}.pt" --max_len $mlen --partial_target
	echo "created ${tgt}/test_neg_${ttype}_bin${b}.pt"
	python preprocess.py --infile "${src}/test_${ttype}_bin${b}.txt" --outfile "${tgt}/test_${ttype}_bin${b}.pt" --max_len $mlen --partial_target
	echo "created ${tgt}/test_${ttype}_bin${b}.pt"

done